/*
 * Copyright (C) 2000, 2001, 2002, 2003, 2004 Broadcom Corporation
 * Copyright (C) 2004 by Ralf Baechle (ralf@linux-mips.org)
 * Copyright (C) 2007 Onstor Inc.
 * Author: Andrew Sharp, andy.sharp@onstor.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*
 * Setup code for the Cougar management processor
 */
#include <linux/bootmem.h>

#include <asm/irq.h>
#include <asm/time.h>
#include <asm/traps.h>
#include <asm/sibyte/sb1250.h>
#if defined(CONFIG_SIBYTE_BCM1x55) || defined(CONFIG_SIBYTE_BCM1x80)
#include <asm/sibyte/bcm1480_regs.h>
#elif defined(CONFIG_SIBYTE_SB1250) || defined(CONFIG_SIBYTE_BCM112X)
#include <asm/sibyte/sb1250_regs.h>
#else
#error invalid OnStor board configuration
#endif

#ifdef CONFIG_EARLY_PRINTK
extern void sb1250_serial_console_init(void);
#endif

#include <asm/mach-cougar/cougar.h>

void *cougar_fpga_base;
void *mcpu_shared_memory;

extern void (*late_time_init)(void);
#if defined(CONFIG_SIBYTE_BCM1x55) || defined(CONFIG_SIBYTE_BCM1x80)
extern void bcm1480_setup(void);
#elif defined(CONFIG_SIBYTE_SB1250) || defined(CONFIG_SIBYTE_BCM112X)
extern void sb1250_setup(void);
#else
#error invalid SiByte board configuration
#endif
extern void cougar_wd_setup(void);

 const char *
get_system_type(void)
{
	return "ONStor Cougar";
}

 void __init
plat_timer_setup(struct irqaction *irq)
{
	/*
	 * we don't set up irqaction, because we will deliver timer
	 * interrupts through the low-level (direct) mechanism.
	 */
	sb1250_time_init();
}

 int
cougar_be_handler(struct pt_regs *regs, int is_fixup)
{
	if (!is_fixup && (regs->cp0_cause & 4)) {
		/* Data bus error - print PA */
		printk("DBE physical address: %010Lx\n",
		       __read_64bit_c0_register($26, 1));
	}
	return (is_fixup ? MIPS_BE_FIXUP : MIPS_BE_FATAL);
}


 void __init
plat_mem_setup(void)
{

	cougar_fpga_base = (void *)COUGAR_FPGA_VADDR;

#if defined(CONFIG_SIBYTE_BCM1x55) || defined(CONFIG_SIBYTE_BCM1x80)
	bcm1480_setup();
#elif defined(CONFIG_SIBYTE_SB1250) || defined(CONFIG_SIBYTE_BCM112X)
	sb1250_setup();
#else
# error invalid ONStor board configuration
#endif

	panic_timeout = 5;  /* For debug.  */

	board_time_init = sb1250_hpt_setup;
	board_be_handler = cougar_be_handler;

	late_time_init = cougar_wd_setup;

	printk("This kernel optimized for ONStor Cougar "
#ifdef CONFIG_SIMULATION
	       "simulation"
#else
	       "board"
#endif
	       " without CFE\n");
}
