/*
 * Copyright (C) 2000, 2001 Broadcom Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/blkdev.h>
#include <linux/bootmem.h>
#include <linux/smp.h>
#include <linux/initrd.h>
#include <linux/pm.h>
#include <linux/types.h>

#include <asm/bootinfo.h>
#include <asm/reboot.h>
#include <asm/pmon.h>
#include <asm/sibyte/sb1250.h>
#if defined(CONFIG_SIBYTE_BCM1x55) || defined(CONFIG_SIBYTE_BCM1x80)
#include <asm/sibyte/bcm1480_regs.h>
#elif defined(CONFIG_SIBYTE_SB1250) || defined(CONFIG_SIBYTE_BCM112X)
#include <asm/sibyte/sb1250_regs.h>
#else
#error invalid OnStor board configuration
#endif
#include <asm/sibyte/bcm1480_scd.h>

#include <asm/mach-tuxrx/tuxrx.h>

#ifdef CONFIG_EARLY_PRINTK
extern void sb1250_serial_console_init(void);
#endif

#ifdef CONFIG_RTC_DRV_DS1511
extern void ds1511_wdog_set(unsigned long deciseconds);
#endif

unsigned long cg_memsize;
unsigned long ipaddr = 0;
unsigned long netmask = 0;
unsigned long cpu_clock;
unsigned long bus_clock;
struct callvectors *debug_vectors;
extern void *mcpu_shared_memory;

static void __init
prom_meminit(void)
{
#ifdef CONFIG_BLK_DEV_INITRD
	unsigned long initrd_pstart;
	unsigned long initrd_pend;

	initrd_pstart = __pa(initrd_start);
	initrd_pend = __pa(initrd_end);
	if (initrd_start &&
	    ((initrd_pstart > MAX_RAM_SIZE)
	     || (initrd_pend > MAX_RAM_SIZE))) {
		panic("initrd out of addressable memory");
	}

	add_memory_region(0, initrd_pstart, BOOT_MEM_RAM);
	add_memory_region(initrd_pstart, initrd_pend - initrd_pstart,
			  BOOT_MEM_RESERVED);

	add_memory_region(initrd_pend, 0x10000000UL - initrd_pend, BOOT_MEM_RAM);

#else
	add_memory_region(0x0UL, TUXRX_RAM1_SZ, BOOT_MEM_RAM);
#endif

	/*
	 * add the rest ... of the memory
	 */
	add_memory_region(TUXRX_RAM2_START, TUXRX_RAM2_SZ, BOOT_MEM_RAM);
	add_memory_region(TUXRX_RAM3_START, TUXRX_RAM3_SZ, BOOT_MEM_RAM);
	add_memory_region(TUXRX_RAM4_START, TUXRX_RAM4_SZ, BOOT_MEM_RAM);
	/*
	 * shared memory for communicating with phantoms
	 */
	//add_memory_region(0x8f000000UL, 0x1000000UL, BOOT_MEM_RESERVED);
	//mcpu_shared_memory = ioremap(0x8f000000UL, 0x1000000UL);
}

void
prom_cpu0_exit(void *unused)
{
        while (1) ;
}

static void
prom_linux_restart(void)
{
#ifdef CONFIG_SMP
	if (smp_processor_id()) {
		smp_call_function(prom_cpu0_exit, NULL, 1, 1);
	}
#endif
	/*
	 * hit the reset button
	 */
#ifdef CONFIG_RTC_DRV_DS1511
	ds1511_wdog_set(300);
#else
	/*
	 * tickle the internal sibyte reset
	 */
	__raw_writeq(M_BCM1480_SYS_SYSTEM_RESET, IOADDR(A_SCD_SYSTEM_CFG));
#endif
	while(1);
}

static void
prom_linux_exit(void)
{
#ifdef CONFIG_SMP
	if (smp_processor_id()) {
		smp_call_function(prom_cpu0_exit, NULL, 1, 1);
	}
#endif
	while(1);
}

/*
 * PMON passes arguments in C main() style
 * */
void __init
cougar_pmon_init(void)
{
	unsigned long argc = fw_arg0;
	char **arg = (char **)fw_arg1;
	char **env = (char **)fw_arg2;
	struct callvectors *cv = (struct callvectors *)fw_arg3;
	char *mac0_addr = NULL;
	char *mac1_addr = NULL;
	int i;

	/*
	 * save the PROM vectors for debugging use
	 */
	debug_vectors = cv;
	if (debug_vectors == NULL) {
		static struct callvectors dv;

		debug_vectors = &dv;
		/*
		 * since our pmon is broken and doesn't legitimately populate
		 * the callvector address, plunk the hardcoded pmon printf
		 * address here.
		 */
		debug_vectors->printf = (void *)0xffffffff88888888;
	}

	printk("Booting Linux kernel...Mips64 TuxRx\n");

	/*
	 * add any boot args from the prom command line to the compiled in
	 * command line.  arg[0] is "g"; the rest is boot parameters.
	 */
#ifndef notyut
	//printk("%s: argc=%ld, arg=%p, env=%p\n", __func__, argc, arg, env);
#endif
	for (i = 1; i < argc; i++) {
		if (strlen(arcs_cmdline) + strlen(arg[i] + 1) >= sizeof(arcs_cmdline)) {
			break;
		}
		strcat(arcs_cmdline, " ");
		strcat(arcs_cmdline, arg[i]);
	}

#define strtoip(STR, DST) sscanf(STR, "%hhu.%hhu.%hhu.%hhu", (char *)&DST, \
		((char *)&DST) + 1, ((char *)&DST) + 2, ((char *)&DST) + 3);

	for (i = 0; env && *env; env++) {

		printk("prom_init: env[%d] = '%s", i++, *env);
		if (!strncmp("macaddr", *env, 7)) {
			/*
			 * some IDIOT has the mac addr in binary in the env
			 */
			int k;

			for (k = 0; k < 6; k++) {
				printk("%02x%s", (*env)[k + 9] & 0xff,
					k == 5 ? "" : ":");
			}
		}
		printk("'\n");

		if (strncmp("ipaddr", *env, strlen("ipaddr")) == 0) {
			strtoip(*env + strlen("ipaddr="), ipaddr);
			continue;
		}
		if (strncmp("netmask", *env, strlen("netmask")) == 0) {
			strtoip(*env + strlen("netmask="), netmask);
			continue;
		}
		if (strncmp("macaddr0", *env, strlen("macaddr0")) == 0) {
			mac0_addr = *env + strlen("macaddr0=");
			continue;
		}
		if (strncmp("macaddr1", *env, strlen("macaddr1")) == 0) {
			mac1_addr = *env + strlen("macaddr1=");
			continue;
		}
		if (strncmp("memsize", *env, strlen("memsize=")) == 0) {
			cg_memsize = simple_strtol(*env + strlen("memsize="), NULL, 10);
			continue;
		}
		if (strncmp("cpuclock", *env, strlen("cpuclock")) == 0) {
			cpu_clock = simple_strtol(*env + strlen("cpuclock="), NULL, 10);
			continue;
		}
		if (strncmp("busclock", *env, strlen("busclock")) == 0) {
			bus_clock = simple_strtol(*env + strlen("busclock="), NULL, 10);
		}
	}

}

/*
 * prom_init is called just after the cpu type is determined, from setup_arch()
 */
void __init
prom_init(void)
{

#ifdef CONFIG_EARLY_PRINTK
	sb1250_serial_console_init();
#endif

	cougar_pmon_init();

	_machine_restart   = (void (*)(char *))prom_linux_restart;
	_machine_halt      = prom_linux_exit;
	pm_power_off = prom_linux_exit;

	mips_machgroup = MACH_GROUP_ONSTOR;
	mips_machtype = MACH_ONSTOR_TUXRX;
	prom_meminit();
}

void __init
prom_free_prom_memory(void)
{
}

 unsigned long __init
signext(unsigned long addr)
{
	addr &= 0xffffffff;
	return (unsigned long)((int)addr);
}


#ifdef CONFIG_SMP
void __init
plat_prepare_cpus(unsigned int max_cpus)
{
}

void
prom_smp_finish(void)
{
	extern void bcm1480_smp_finish(void);
	bcm1480_smp_finish();
}

void __init
prom_init_secondary(void)
{
	extern void bcm1480_smp_init(void);
	bcm1480_smp_init();
}

#define ONSTOR_PMON_SECONDARY_VECTORS 0xffffffffbfc0052cULL

/*
 * get idle task running on secondary cpu.
 *
 * highly onstor specific, and hopefully we can fix that in a later
 * PROM release.  Some numb-nuts did the layout of the start
 * vectors for the additional cpu's in a very stupid way.
 * the vectors for each CPU are in the same cache line, so
 * the cores fight over the cache line lock each time they spin.
 *
 * we need to switch it to put the per cpu data all in one,
 * cache line, LGI
 */
void
prom_boot_secondary(int cpu, struct task_struct *idle)
{
	unsigned long gp = (unsigned long) task_thread_info(idle);
	unsigned long sp = __KSTK_TOS(idle);
	typedef void * vecs[4][4];
	vecs *some_vectors = *(void **)(ONSTOR_PMON_SECONDARY_VECTORS);

	some_vectors = (void *)signext((u64)some_vectors);

	/*
	 * stuff the magic dragon...
	 */
	(*some_vectors)[1][cpu] = (void *)sp;
	(*some_vectors)[2][cpu] = (void *)gp;
	(*some_vectors)[3][cpu] = (void *)(u64)cpu;
	(*some_vectors)[0][cpu] = smp_bootstrap; /* and off she goes ... ? */
}

/*
 * Final cleanup after all secondaries booted
 */
void
prom_cpus_done(void)
{
}

#endif /* CONFIG_SMP */

void
prom_putchar(char c)
{
}
