/*
 * Copyright (C) 2000, 2001, 2002, 2003, 2004 Broadcom Corporation
 * Copyright (C) 2004 by Ralf Baechle (ralf@linux-mips.org)
 * Copyright (C) 2007 Onstor Inc.
 * Author: Andrew Sharp, andy.sharp@onstor.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*
 * Setup code for the Cougar management processor
 */
#include <linux/bootmem.h>

#include <asm/irq.h>
#include <asm/time.h>
#include <asm/traps.h>
#include <asm/sibyte/sb1250.h>
#if defined(CONFIG_SIBYTE_BCM1x55) || defined(CONFIG_SIBYTE_BCM1x80)
#include <asm/sibyte/bcm1480_regs.h>
#elif defined(CONFIG_SIBYTE_SB1250) || defined(CONFIG_SIBYTE_BCM112X)
#include <asm/sibyte/sb1250_regs.h>
#else
#error invalid OnStor board configuration
#endif

#ifdef CONFIG_EARLY_PRINTK
extern void sb1250_serial_console_init(void);
#endif

#include <tuxrx.h>

void *mcpu_shared_memory;

extern void (*late_time_init)(void);
#if defined(CONFIG_SIBYTE_BCM1x55) || defined(CONFIG_SIBYTE_BCM1x80)
extern void bcm1480_setup(void);
#elif defined(CONFIG_SIBYTE_SB1250) || defined(CONFIG_SIBYTE_BCM112X)
extern void sb1250_setup(void);
#else
#error invalid SiByte board configuration
#endif
extern void cougar_wd_setup(void);

 const char *
get_system_type(void)
{
	return "ONStor TuxRx";
}

 void __init
plat_timer_setup(struct irqaction *irq)
{
	/*
	 * we don't set up irqaction, because we will deliver timer
	 * interrupts through the low-level (direct) mechanism.
	 */
#if defined(CONFIG_SIBYTE_BCM1x55) || defined(CONFIG_SIBYTE_BCM1x80)
	bcm1480_time_init();
#elif defined(CONFIG_SIBYTE_SB1250) || defined(CONFIG_SIBYTE_BCM112X)
	sb1250_time_init();
#endif
}

 int
cougar_be_handler(struct pt_regs *regs, int is_fixup)
{
	if (!is_fixup && (regs->cp0_cause & 4)) {
		/* Data bus error - print PA */
		printk("DBE physical address: %010Lx\n",
		       __read_64bit_c0_register($26, 1));
	}
	return (is_fixup ? MIPS_BE_FIXUP : MIPS_BE_FATAL);
}

#ifdef CONFIG_SMP
/*
 * Assume cpus are already set up by whatever prom is in the system.
 * Set up phys_cpu_present_map and the logical/physical mappings.
 *
 * Common setup before any secondaries are started
 */
void __init
plat_smp_setup(void)
{
	int i, num;

	cpus_clear(phys_cpu_present_map);
	cpu_set(0, phys_cpu_present_map);
	__cpu_number_map[0] = 0;
	__cpu_logical_map[0] = 0;

	for (i = 1, num = 0; i < NR_CPUS; i++) {
		cpu_set(i, phys_cpu_present_map);
		__cpu_number_map[i] = ++num;
		__cpu_logical_map[num] = i;
	}
	printk(KERN_INFO "Detected %i available secondary CPU(s)\n", num);

	/*
	 * special sauce for reserving memory chunk for sharing with
	 * SSC and FP
	 */
	reserve_bootmem(SHARED_MEM_START, SHARED_MEM_MGMT_SIZE);
}
#endif

 void __init
plat_mem_setup(void)
{

#if defined(CONFIG_SIBYTE_BCM1x55) || defined(CONFIG_SIBYTE_BCM1x80)
	bcm1480_setup();
#elif defined(CONFIG_SIBYTE_SB1250) || defined(CONFIG_SIBYTE_BCM112X)
	sb1250_setup();
#else
# error invalid ONStor board configuration
#endif

	panic_timeout = 5;  /* For debug.  */

#if defined(CONFIG_SIBYTE_BCM1x55) || defined(CONFIG_SIBYTE_BCM1x80)
	board_time_init = bcm1480_hpt_setup;
#elif defined(CONFIG_SIBYTE_SB1250) || defined(CONFIG_SIBYTE_BCM112X)
	board_time_init = sb1250_hpt_setup;
#else
# error invalid ONStor board configuration
#endif

	board_be_handler = cougar_be_handler;

	late_time_init = cougar_wd_setup;

	printk("This kernel optimized for ONStor Cougar "
#ifdef CONFIG_SIMULATION
	       "simulation"
#else
	       "TuxRx Processor"
#endif
	       " without CFE\n");
}
