/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Marvell MV64440 interrupt fixup code.
 *
 * Marvell wants an NDA for their docs so this was written without
 * documentation.  You've been warned.
 *
 * Copyright (C) 2007 Andrew Sharp (andy.sharp@onstor.com)
 *
 * Pmon prom should initialize the PCI configuration headers for
 * the pci-pcmcia controller chip (intel pd-6729) and the natsemi
 * ethernet chip (dp-83816).
 * pd-6729:	irq = 10	bar0/IO = 0x18000000	size = 8MB
 *						bar1/MEM = 0x18800000	size = 8MB
 * dp-83816: 0	irq = 8		bar0/MEM = 0x19000000	size = 4KB
 *		     1	irq = 9		bar0/MEM = 0x19001000	size = 4KB
 *
 * Copyright (C) 2007, Onstor, Inc.
 * Author Andrew Sharp (andy.sharp@onstor.com)
 */
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/pci.h>

#include <asm/pci.h>
#include <asm/io.h>
#include <asm/mipsregs.h>

#define BOBCAT_ENET_IRQ	8
#define BOBCAT_CF_IRQ	10
#define BOBCAT_CF_SLOT1_IRQ	10
#define BOBCAT_CF_SLOT2_IRQ	11

/*
 *
 */
 int __init
pcibios_map_irq(struct pci_dev *dev, u8 slot, u8 pin)
{
	if ((dev->vendor == PCI_VENDOR_ID_NS) &&
		(dev->device == PCI_DEVICE_ID_NS_83815)) {

		/*
		 * the two ns83815 controllers are in PCI slots 0 and 1
		 */
		return PCI_SLOT(dev->devfn) + BOBCAT_ENET_IRQ;
	}
	if (dev->vendor == PCI_VENDOR_ID_CIRRUS) {
		/*
		 * the cirrus pcmcia bridge shows one device in slot 2
		 */
		//return BOBCAT_CF_IRQ;
		return 0; /* make it poll */
	}
	if ((dev->vendor == PCI_VENDOR_ID_TI) &&
		(dev->device == PCI_DEVICE_ID_TI_1520)) {

		/*
		 * the TI pcmcia bridge shows as two (multi)funcs 0 and 1, in slot 2
		 */
		//return BOBCAT_CF_IRQ;
		return 0; /* make it poll */
	}

	return dev->irq;
}

/*
 * Do platform specific device initialization at pci_enable_device() time
 */
 int
pcibios_plat_dev_init(struct pci_dev *dev)
{
	return 0;
}

struct resource cf_init_res[] = {
	{
		.start = 0x18000000,
		.end =   0x180000ff,
		.flags = IORESOURCE_IO,
	},
	{
		.start = 0x18800000,
		.end =   0x18ffffff,
		.flags = IORESOURCE_MEM ,//| IORESOURCE_PCI_FIXED,
	},
};

struct resource natsemi_init_res[] = {
	{
		.start = 0x800000,
		.end = 0x800fff,
		.flags = IORESOURCE_MEM,
	},
	{
		.start = 0x1000000,
		.end = 0x1000fff,
		.flags = IORESOURCE_MEM,
	},
};

/*
 * fixup the cirrus pci-pcmcia chip.
 */
 static void
bobcat_pci_pcmcia_6729_fixup_header(struct pci_dev *dev)
{
	//dev->resource[0].start = cf_init_res[0].start;
	//dev->resource[0].end = cf_init_res[0].end;
	//dev->resource[0].flags = cf_init_res[0].flags;
	dev->resource[1].start = cf_init_res[1].start;
	dev->resource[1].end = cf_init_res[1].end;
	dev->resource[1].flags = cf_init_res[1].flags;
	//dev->resource[2].start = cf_init_res[2].start;
	//dev->resource[2].end = cf_init_res[2].end;
	//dev->resource[2].flags = cf_init_res[2].flags;
	dev->resource[6].start = 0;
	dev->resource[6].end = 0;
	dev->resource[6].flags = 0;
	dev->dma_mask = 0xffffff;
}

/*
 * fixup the texas instruments pcmcia chip.
 */
 static void
bobcat_pci_pcmcia_1520_fixup_header(struct pci_dev *dev)
{
	static int unit = 0;

	dev->resource[0].start += cf_init_res[1].start + (unit * 0x1000);
	dev->resource[0].end += dev->resource[0].start;
	//dev->dma_mask = 0xffffff;

	unit++;
}

/*
 * fixup the natsemi ethernet chip.
 */
 static void
bobcat_pci_ns_83816_fixup_header(struct pci_dev *dev)
{
	static int unit = 0;

	dev->resource[0].start = 0;
	dev->resource[0].end = 0;
	dev->resource[0].flags = 0;
	dev->resource[1].start = natsemi_init_res[unit].start;
	dev->resource[1].end = natsemi_init_res[unit].end;
	dev->resource[1].flags = natsemi_init_res[unit].flags;
	dev->resource[6].start = 0;
	dev->resource[6].end = 0;
	dev->resource[6].flags = 0;
	unit++;
}

DECLARE_PCI_FIXUP_HEADER(PCI_VENDOR_ID_NS, PCI_DEVICE_ID_NS_83815,
    bobcat_pci_ns_83816_fixup_header);

DECLARE_PCI_FIXUP_HEADER(PCI_VENDOR_ID_TI, PCI_DEVICE_ID_TI_1520,
	bobcat_pci_pcmcia_1520_fixup_header);

DECLARE_PCI_FIXUP_HEADER(PCI_VENDOR_ID_CIRRUS, PCI_DEVICE_ID_CIRRUS_6729,
	bobcat_pci_pcmcia_6729_fixup_header);
