/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * SiByte 1125H interrupt fixup code for Onstor Cougar platform
 *
 * Pmon prom should initialize the PCI configuration headers for
 * the pci-pcmcia controller chip (TI 1504).

 * ti-1520	irq = 56
 *
 *
 * Copyright (C) 2007, Onstor, Inc.
 * Author Andrew Sharp (andy.sharp@onstor.com)
 */
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/pci.h>

#include <asm/pci.h>
#include <asm/io.h>
#include <asm/mipsregs.h>

#define COUGAR_CF_IRQ	56

/*
 * paste in the irqs for the CF controller
 * these really should be probe-able
 */
 int __init
pcibios_map_irq(struct pci_dev *dev, u8 slot, u8 pin)
{
	if ((dev->vendor == PCI_VENDOR_ID_TI) &&
		(dev->device == PCI_DEVICE_ID_TI_1520)) {

		/*
		 * the TI pcmcia bridge shows as two (multi)funcs 0 and 1, in slot 2
		 */
		return COUGAR_CF_IRQ + pin - 1;
	}

	return dev->irq;
}

