/*
 *-----------------------------------------------------------------
 *
 * Name:	amd29f040.h
 *
 * RCS:  $Id: amd29f040.h,v 1.4 2002/08/16 06:52:52 johnh Exp $
 *
 * Copyright (C) 2001, Agile Storage, Inc.
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	10/8/01
 *
 *-----------------------------------------------------------------
 */

#ifndef _AMD29F040_H
#define _AMD29F040_H

#ifdef SSC_MGMT
/* Device Specs */
#define FROM_SECTORSIZE		(0x10000 << 1)		/* bytes per block */
#define FROM_SECTORMASK		(FROM_SECTORSIZE - 1)
#define FROM_MAXSECTORS		(8 >> 1)			/* sectors per chip */
#define FROM_MAX_BYTES		(FROM_MAXSECTORS * FROM_SECTORSIZE)
#define FROM_SECTOR_OFFSET_SHIFT	17

/* Mfg / Device ID's */
#define MAN_AMD				0x0101
#define MAN_STM				0x2020
#define DEV_29F040			0xA4A4
#define DEV_29LV040			0x4F4F
#define DEV_29LV017			0xC8C8
#define DEV_29LV033			0xA3A3
#define DEV_M29W040			0xE3E3

/* Command Codes */
#define CMD_UNLOCK_ADDR1	(0x5555 << 1)
#define CMD_UNLOCK_ADDR2	(0x2AAA << 1)
#define CMD_ADDR3			(0x5555 << 1)

#define CMD_DATA1			0xAAAA
#define CMD_DATA2			0x5555

/* command codes */
#define CMD_DATA_RESET		0xF0F0
#define CMD_DATA_AUTOSELECT	0x9090
#define CMD_DATA_PROGRAM	0xA0A0
#define CMD_DATA_ERASE		0x8080
#define CMD_DATA_ERASESECT	0x3030
#define CMD_DATA_ERASECHIP	0x1010

/* data bit definitions for "embedded programming algorithm" */
#define DQPOLL				0x8080
#define DQTOGGLE			0x4040
#define DQTIMEEXCEEDED		0x2020
#define DQSECTERASETIMER	0x0808

#else

/* Device Specs */
#define FROM_SECTORSIZE		0x10000		/* bytes per block */
#define FROM_SECTORMASK		(FROM_SECTORSIZE - 1)
#define FROM_MAXSECTORS		8			/* sectors per chip */
#define FROM_MAX_BYTES		(FROM_MAXSECTORS * FROM_SECTORSIZE)
#define FROM_SECTOR_OFFSET_SHIFT	16

/* Mfg / Device ID's */
#define MAN_AMD				0x01
#define MAN_STM				0x20
#define DEV_29F040			0xA4
#define DEV_29LV040			0x4F
#define DEV_29LV017			0xC8
#define DEV_29LV033			0xA3
#define DEV_M29W040			0xE3

/* Command Codes */
#define CMD_UNLOCK_ADDR1	0x5555
#define CMD_UNLOCK_ADDR2	0x2AAA
#define CMD_ADDR3			0x5555

#define CMD_DATA1			0xAA
#define CMD_DATA2			0x55

/* command codes */
#define CMD_DATA_RESET		0xF0
#define CMD_DATA_AUTOSELECT	0x90
#define CMD_DATA_PROGRAM	0xA0
#define CMD_DATA_ERASE		0x80
#define CMD_DATA_ERASESECT	0x30
#define CMD_DATA_ERASECHIP	0x10

/* data bit definitions for "embedded programming algorithm" */
#define DQPOLL				0x80
#define DQTOGGLE			0x40
#define DQTIMEEXCEEDED		0x20
#define DQSECTERASETIMER	0x08
#endif

#define AMD_29F040_STR              "AMD Am29F040"
#define AMD_29LV040_STR             "AMD Am29LV040"
#define AMD_29LV017_STR             "AMD Am29LV017"
#define AMD_29LV033_STR             "AMD Am29LV033"
#define ST_M29W040_STR              "STM M29W040"

#define AMD_29F040_MAX_SECTORS      (FROM_MAXSECTORS)
#define AMD_29LV040_MAX_SECTORS     (FROM_MAXSECTORS)
#define AMD_29LV017_MAX_SECTORS     (32)
#define AMD_29LV033_MAX_SECTORS     (64)
#define ST_M29W040_MAX_SECTORS     (FROM_MAXSECTORS)

#define AMD_29F040_SIZE             (FROM_SECTORSIZE * AMD_29F040_MAX_SECTORS)
#define AMD_29LV040_SIZE            (FROM_SECTORSIZE * AMD_29LV040_MAX_SECTORS)
#define AMD_29LV017_SIZE            (FROM_SECTORSIZE * AMD_29LV017_MAX_SECTORS)
#define AMD_29LV033_SIZE            (FROM_SECTORSIZE * AMD_29LV033_MAX_SECTORS)
#define ST_M29W040_SIZE            (FROM_SECTORSIZE * ST_M29W040_MAX_SECTORS)

#define FROM_SINGLE_PROM_CFG        1
#define FROM_RECOV_PROM_CFG         2


#define FROM_SECTOR_NUM(off)	(((off) & ~(FROM_SECTORSIZE-1)) >> FROM_SECTOR_OFFSET_SHIFT)
#define FROM_SECTOR_OFFSET(off)	((off) & (FROM_SECTORSIZE-1))

#endif	/* _AMD29F040_H */

