/*
 *-----------------------------------------------------------------
 *
 * Name:	from-api.h
 *
 * RCS:  $Id: from-api.h,v 1.10 2002/11/06 22:46:06 maximk Exp $
 *
 * Copyright (C) 2001, Agile Storage, Inc.
 *
 * Description:	Flash ROM API functions
 *
 * Created by:	Rick Lund
 *
 * Date Created:	10/8/01
 *
 *-----------------------------------------------------------------
 */

#define R7000 1

#include "amd29f040.h"

#ifdef SSC_MGMT
#define TYPE_LEN    uint16_t
#else
#define TYPE_LEN    uint8_t
#endif

#define FROM_CBX_PRIMARY   0
#define FROM_CBX_ALTERNATE 1

#define HW_PROM_BASE 0x1f600000
#define HW_BIG_BOOTROM_BASE 0x1f800000

void    from_init(void);
int     from_cfg_proms(void);
int32_t	from_programbytes(int32_t offset, TYPE_LEN * src_buf, uint32_t len);
int32_t	from_readbytes(int32_t offset, uint8_t * dest_buf, uint32_t len);
void    from_print_info(void);

/* status returned by above functions */
#define FROM_ERR_FAIL		-EINVAL	/* parameter error */
#define FROM_ERR_PROTECTED	-EACCES
											/* can't program protected sector */
#define FROM_ERR_PARTIAL	-EIO
												/* can't erase partial sector */
#define FROM_ERR_NOMEM		-ENOMEM
													/* no memory for buffer */
#define FROM_ERR_FATAL		-EIO
												/* fatal programming error */

#define FROM_SEL_INVALID    (-1)

struct prom_part_cb;
struct prom_part_desc;

unsigned long from_get_base(void);
uint32_t      from_get_size(void);
uint32_t      from_get_sectors(void);
void        from_set_primary(void);
void        from_set_alternate(void);
void        from_set_current(int select);
int         from_swap_base(void);
int         from_select_recov(void);
int         from_select_std(void);
int32_t       from_upgrade(uint32_t	ip, uint8_t	* fname, uint32_t	fetch_fp);

extern void from_old_prom_print(uint8_t *buf);
extern int from_old_prom_type(uint8_t *buf, int32_t prom_len);
extern int from_check_old_prom_type(uint8_t *buf, int len);
extern int from_get_prom_info(char *buf, int len, struct prom_part_cb **,
							  struct prom_part_desc **);
extern int from_device_present(int id);

extern int from_current;
extern int primary_is_rprom;
extern int from_probed_proms;

#define FROM_BASE                   (from_get_base())
#define FROM_SIZE                   (from_get_size())
#define FROM_SECS                   (from_get_size()/FROM_SECTORSIZE)
#define FROM_ADDR(_tcast, _offs)    ((_tcast)(FROM_BASE +  (_offs)))

#define FROM_MAX_SIZE               AMD_29LV033_SIZE

/* The offset of the crash dump area from the end of the flash.
 */
#define FROM_CRASHDUMP_OFFSET_FROM_END (16*1024)

#if defined(FCNIM) && defined(BOBCAT)
// Not to conflict with SSC crashdump, 
// move FCNIM_BC crash dump location 16K lower 
#define FROM_CRASHDUMP_OFFSET       (FROM_SIZE - FROM_CRASHDUMP_OFFSET_FROM_END * 2)        
#else
#define FROM_CRASHDUMP_OFFSET       (FROM_SIZE - FROM_CRASHDUMP_OFFSET_FROM_END)        
#endif


#if defined(PROM_SIBYTE) || defined(PROM_R7000)
/*
 * size the prom_upgrade area to be the large flash size plus extra 2MB
 * we're using load area in memory so there's plenty of space
 */
#define PROM_UPGRADE_MAX_SIZE       (FROM_MAX_SIZE + (2*1024*1024))
extern uint8_t * prom_upgrade_area;
#else
/*
 * size the prom_upgrade area to be the large flash size plus extra 4K
 */
#define PROM_UPGRADE_MAX_SIZE       (FROM_MAX_SIZE + 4096)
extern uint8_t prom_upgrade_area[PROM_UPGRADE_MAX_SIZE];
#endif

#ifdef FAKE_SEEP_ON_FLASH_WAR
#define FROM_FAKE_SEEP_OFFSET       (FROM_CRASHDUMP_OFFSET - SEEP_TOTAL_LEN)       
#endif
