/*
 *-----------------------------------------------------------------
 *
 * Name:    rcon.h
 *
 * Copyright (C) 2007, Onstor, Inc.
 *
 * Description: definitions for shared memory fp/txrx remote console.
 *
 *-----------------------------------------------------------------
 */

#ifndef RCON_H
#define RCON_H

/*
 * Rcon definitions should be kept in sync with nfx-tree/code/sm-eee/eee.h
 */


/* 
 * Number of cores connected to console.
 */
#define RCON_MAX_CORES 8

/* 
 * The remote console circular buffer size.
 */
#define SM_RCON_QUEUE_MAX 512

/* 
 * Queue structure.
 */
struct rcon_queue
{
    /* 
     * The number of bytes written to the queue by this cpu.
     */
    uint64_t bytes_i_wrote;

    /* 
     * The number of bytes the remote cpu read from the queue. This
     * field is updated by the remote cpu only.
     */
    uint64_t bytes_peer_read;

    uint32_t pad[4];

    /*
     * The number of bytes the remote cpu wrote to the queue. This field
     * is updated by the remote cpu only.
     */
    uint64_t bytes_peer_wrote;

    /*
     * The number of bytes this cpu read from the queue.
     */
    uint64_t bytes_i_read;
    uint32_t pad_1[4];

    /*
     * The circular buffer.
     */
    char data[SM_RCON_QUEUE_MAX];
};


#endif
