/*
 * Copyright 2003 PMC-Sierra
 * Author: Manish Lachwani (lachwani@pmc-sierra.com)
 *
 * Copyright 2007 Onstor
 * Author: Andrew Sharp (andy.sharp@onstor.com)
 *
 * Board specific definititions for the Onstor Cougar
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

#ifndef __COUGAR_DEP_H__
#define __COUGAR_DEP_H__

#define ONS_PLAT COUGAR

#define ONSTOR_FPGA_READ COUGAR_FPGA_READ
#define ONSTOR_BMPGA_MSG_IN_IRQ COUGAR_BMPGA_MSG_IN_IRQ

#include <asm/addrspace.h>              /* for KSEG1ADDR() */
#include <asm/byteorder.h>              /* for cpu_to_le32() */

#define COUGAR_READ(ofs)							\
	(*(volatile u32 *)(ocd_base+(ofs)))
#define COUGAR_READ_16(ofs)						\
	(*(volatile u16 *)(ocd_base+(ofs)))
#define COUGAR_READ_8(ofs)						\
	(*(volatile u8 *)(ocd_base+(ofs)))

#define COUGAR_WRITE(ofs, data)						\
	do { *(volatile u32 *)(ocd_base+(ofs)) = (data); } while (0)
#define COUGAR_WRITE_16(ofs, data)					\
	do { *(volatile u16 *)(ocd_base+(ofs)) = (data); } while (0)
#define COUGAR_WRITE_8(ofs, data)					\
	do { *(volatile u8 *)(ocd_base+(ofs)) = (data); } while (0)

/*
 * fake debug_vectors -- we aren't using the one defined in pmon.h
 * because we have wired up some special ones of our own, and also,
 * our pmon is old and out of sync, mostly, with that definition.
 */
struct onstor_vectors {
	int	(*printf) (const char*, ...) __attribute__((format(printf, 1, 2)));
	int	(*tty1_printf) (const char*, ...) __attribute__((format(printf, 1, 2)));
};

extern struct onstor_vectors *coug_vectors;

/*
 * a locking printk to debug serial port 1
 */
#define coug_tty1_printk(F, ...)		do {                              \
	int bc_flags;                                                     \
	extern spinlock_t bc_tty1_lock;                                   \
	spin_lock_irqsave(bc_tty1_lock, bc_flags);                        \
	panic(F, ##__VA_ARGS__);                       \
	spin_unlock_irqrestore(bc_tty1_lock, bc_flags);                   \
} while (0)
	//coug_vectors->tty1_printf(F, ##__VA_ARGS__);                       

/*
 * cougar platform debug printk macro
 */
#ifdef CONFIG_DEBUG_KERNEL
# define coug_dbg(fmt, ...) \
	coug_tty1_printk("%s: " fmt "\n", __func__, ##__VA_ARGS__)
#else
# define coug_dbg(fmt, ...) while (0)
#endif

# define dprintk(fmt, ...) printk(KERN_INFO "%s: " fmt "\n", __func__, ##__VA_ARGS__)

/*
 * various base address defines
 */
#define COUGAR_FPGA_PADDR		0x1f400000ULL
#define COUGAR_RTC_PADDR		0x1f000000UL
#define COUGAR_RTC_SIZE			0x1000
#define COUGAR_FPGA_VADDR		PHYS_TO_XKSEG_UNCACHED(COUGAR_FPGA_PADDR)
#define COUGAR_PROM_SZ			0x2000000UL		/* 32MiB - time for a diet */

#define SHARED_MEM_START	0x8f000000UL
#define SHARED_MEM_SIZE		0x01000000UL/* 16 MiB */

/*
 * The memory map for the shared memory.  Allocate statically because the FC
 * code depends on the FC messaging pool starting right after the SSC message
 * pool.
 */
#define SHARED_MGMT_OFF 0x0
#define SHARED_MEM_MGMT (SHARED_MEM_START + SHARED_MGMT_OFF)
#define SHARED_MEM_MGMT_SIZE 0x1000000 /* 16 MiB */

/*
 * PCI specific defines
 */

/*
 * shared memory map.
 */
struct _shared_memregion {
	unsigned long pa_start;
	unsigned long pa_end;
	unsigned long va_start;
};

/*
 * SEEP - Serial EEPROM defines
 */
#define SEEP_SIG_LEN				(4+1)
#define	SEEP_PCB_MODEL_LEN			(9+1)
#define	SEEP_PCB_ASSEMBLY_LEN		(13+1)
#define	SEEP_PCB_SERIAL_LEN			(10+1)
#define	SEEP_PCB_REVISION_LEN		(4+1)
#define	SEEP_PCB_DEVIATION_LEN		(11+1)
#define	SEEP_PCB_IP_ADDR_LEN		(15+1)
#define	SEEP_PCB_IP_MASK_LEN		(15+1)
#define	SEEP_PCB_DIAG_TEST_LEN		(1+1)
#define	SEEP_PCB_RESULT_LEN		(1+1)
#define	SEEP_PCB_DATE_LEN		(6+1)
#define	SEEP_PCB_MISC_INFO_LEN		(8+1)
#define	SEEP_PCB_UPTIME_LEN		(3+1)
#define	SEEP_PCB_REBOOTNUM_LEN		(1+1)

#define SEEP_CHASSIS_MODEL_LEN		(15+1)
#define	SEEP_CHASSIS_SERIAL_LEN		(10+1)
#define	SEEP_CHASSIS_REVISION_LEN	(5+1)
#define	SEEP_CHASSIS_DEVIATION_LEN	(5+1)
#define SEEP_CHASSIS_MAC_ADDR_LEN	(12+1)
#define	SEEP_CHASSIS_UPTIME_LEN		(4+1)
#define	SEEP_CHASSIS_REBOOTNUM_LEN	(1+1)

#define SEEP_ENV_START		147
#define SEEP_NVRAM_START	179
#define SEEP_VER_STRING_LEN_SIZE  (SEEP_TOTAL_LEN - SEEP_NVRAM_START - 1)

/*
 * HT specific defines
 */

#endif
