/*
 * Copyright 2003 PMC-Sierra
 * Author: Manish Lachwani (lachwani@pmc-sierra.com)
 *
 * Copyright 2007,2008 Onstor
 * Author: Andrew Sharp (andy.sharp@onstor.com)
 *
 * Board specific definititions for the Onstor Cougar
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

#ifndef __TUXRX_DEP_H__
#define __TUXRX_DEP_H__

#define ONS_PLAT TUXRX

#include <asm/addrspace.h>              /* for KSEG1ADDR() */
#include <asm/byteorder.h>              /* for cpu_to_le32() */

/*
 * fake debug_vectors -- we aren't using the one defined in pmon.h
 * because we have wired up some special ones of our own, and also,
 * our pmon is old and out of sync, mostly, with that definition.
 */
struct onstor_vectors {
	int	(*printf) (const char*, ...) __attribute__((format(printf, 1, 2)));
	int	(*tty1_printf) (const char*, ...) __attribute__((format(printf, 1, 2)));
};

extern struct onstor_vectors *coug_vectors;

/*
 * a locking printk to debug serial port 1
 */
#define coug_tty1_printk(F, ...)		do {                          \
	int bc_flags;                                                     \
	extern spinlock_t bc_tty1_lock;                                   \
	spin_lock_irqsave(bc_tty1_lock, bc_flags);                        \
	panic(F, ##__VA_ARGS__);                                          \
	spin_unlock_irqrestore(bc_tty1_lock, bc_flags);                   \
} while (0)
	//coug_vectors->tty1_printf(F, ##__VA_ARGS__);                       

/*
 * cougar platform debug printk macro
 */
#ifdef CONFIG_DEBUG_KERNEL
# define coug_dbg(fmt, ...) \
	coug_tty1_printk("%s: " fmt "\n", __func__, ##__VA_ARGS__)
#else
# define coug_dbg(fmt, ...) while (0)
#endif

# define dprintk(fmt, ...) \
	printk(KERN_INFO "%s: " fmt "\n", __func__, ##__VA_ARGS__)

/*
 * tuxrx memory map - 4GB version
 */
#define TUXRX_RAM1_SZ        0x10000000	/* 256 MiB */

#define TUXRX_RAM2_START    0x080000000ULL
#define TUXRX_RAM3_START    0x0c0000000ULL
#define TUXRX_RAM4_START    0x140000000ULL

#define TUXRX_RAM2_SZ        0x20000000    /* 512 MiB */
#define TUXRX_RAM3_SZ        0x10000000    /* 256 MiB */
#define TUXRX_RAM4_SZ        0xc0000000    /* 3   GiB */

/*
 * The BCM1480 has a regrettable bug whereby a memory chunk of 378M
 * starting offset 0xa0000000 in any 4G memory expanse is not visible
 * across the HT bus.  So it can't be shared by other 1480s or
 * devices that might be on the the HT bus.  Very, very inconvenient.
 */
#define SHAREABLE_HOLE_OFF   0x0a0000000ULL
#define SHAREABLE_HOLE_SIZE  0x018000000ULL /* 378 MiB */

/*
 * The physical address of the start of the hole in RAM4 memory
 * area.  This equates to 0x1,e000,0000
 */
#define TUXRX_RAM4_HOLE_START (TUXRX_RAM4_START + SHAREABLE_HOLE_OFF)

/*
 * various base address defines
 * this equates to 0x1,f000,0000
 */
#define SHARED_MEM_START	(TUXRX_RAM4_HOLE_START + (256 * 1024 * 1024))

/*
 * The memory map for the shared memory.
 */
#define SHARED_MGMT_OFF 0x0
#define SHARED_MEM_MGMT (SHARED_MEM_START + SHARED_MGMT_OFF)
#define SHARED_MEM_MGMT_SIZE 0x1000000

/*
 * PCI specific defines
 */
#define PCI_SHARED_MEM_OFF 0x60000000

/*
 * shared memory map.
 */
struct _shared_memregion {
	unsigned long pa_start;
	unsigned long pa_end;
	unsigned long va_start;
};

/*
 * SEEP - Serial EEPROM defines
 */
#define SEEP_SIG_LEN				(4+1)
#define	SEEP_PCB_MODEL_LEN			(9+1)
#define	SEEP_PCB_ASSEMBLY_LEN		(13+1)
#define	SEEP_PCB_SERIAL_LEN			(10+1)
#define	SEEP_PCB_REVISION_LEN		(4+1)
#define	SEEP_PCB_DEVIATION_LEN		(11+1)
#define	SEEP_PCB_IP_ADDR_LEN		(15+1)
#define	SEEP_PCB_IP_MASK_LEN		(15+1)
#define	SEEP_PCB_DIAG_TEST_LEN		(1+1)
#define	SEEP_PCB_RESULT_LEN		(1+1)
#define	SEEP_PCB_DATE_LEN		(6+1)
#define	SEEP_PCB_MISC_INFO_LEN		(8+1)
#define	SEEP_PCB_UPTIME_LEN		(3+1)
#define	SEEP_PCB_REBOOTNUM_LEN		(1+1)

#define SEEP_ENV_START		147
#define SEEP_NVRAM_START	179
#define SEEP_VER_STRING_LEN_SIZE  (SEEP_TOTAL_LEN - SEEP_NVRAM_START - 1)

/*
 * HT specific defines
 */

#endif
