#ifndef NETEEE_EDESC_H
#define NETEEE_EDESC_H

/*
 * EEE protocol ID in the ethernet header.
 */
#define ETH_P_EEE 0x2200

/*
 * Protocol header.
 */
typedef struct agile_hdr {
    uint16_t pad;
    uint32_t dest_port;
    uint32_t src_port;
    uint32_t offset;         /* Offset of the fragment + more flag*/
    uint16_t h_proto;        /* ETH_P_EEE, ETH_P_IP, ETH_P_IPv6 */
    uint16_t pad__;
} __attribute__ ((packed)) agile_hdr_t;

/* Address family.
 */
#define PF_EEE 30
#define AF_EEE PF_EEE

#define AGILEHDR_MF 0x80000000  /* If this bit is set in agile_hdr->offset,
                                   more fragments follow */
#define AGILEHDR_ID_MASK 0x7ff00000 /* Sequence ID mask */
#define AGILEHDR_ID_SHIFT 24    /* Sequence ID shift */
#define AGILEHDR_ID_MAX (AGILEHDR_ID_MASK >> AGILEHDR_ID_SHIFT)

/*
 * Anonymous port allocation starts here.
 */
#define EEE_RESERVED_APP 1024

#define EDESC2_DATA_TYPE_MASK   0xE0000000
#define EDESC2_DATA_TYPE_SHIFT  29
#define EDESC2_DATA_TYPE_NUM    8
#define EDESC2_PORT_MASK        0x1F000000
#define EDESC2_PORT_SHIFT       24
#define EDESC2_PORT_NUM         32
#define EDESC2_MCAST_IND        0x00800000
#define EDESC2_COS_MASK         0x00600000
#define EDESC2_COS_SHIFT        21
#define EDESC2_COS_NUM          4
#define EDESC2_CPU_MASK         0x001F0000
#define EDESC2_CPU_SHIFT        16
#define EDESC2_CPU_NUM          32
#define EDESC2_SLOT_MASK        0x0000F000
#define EDESC2_SLOT_SHIFT       12
#define EDESC2_SLOT_NUM         16
#define EDESC2_APP_MASK         0x00000FFF
#define EDESC2_APP_SHIFT        0
#define EDESC2_APP_NUM          4096

/*
 * Data type.
 */
#define EEE_MGMT				2

/*
 * SSC cpu types
 */
#define NFX_SSC_NUM_CPUS            2   /* on physical card */
#define NFX_SSC_UNIX                0
#define NFX_SSC_MGMT                1

/*
 * Unknown slot number.
 */
#define NFX_SLOTTYPE_UNKNOWN -1

/*
 * The System Services Controller.
 */
#define NFX_SLOTTYPE_SSC 0

/*
 * The Network File Processor.
 */
#define NFX_SLOTTYPE_NFP 1

/*
 * The Fibre Channel Processor.
 */
#define NFX_SLOTTYPE_FC 2

#define NFX_SLOT_MIN 0

/*
 * The maximum number of slots we ever expect.
 */
#define NFX_SLOT_MAX 11

#define NFX_NUM_SLOTS_PER_CHASSIS   (NFX_SLOT_MAX + 1)

/*
 * CPU identifiers
 */
#define NFX_MAX_CPUS_PER_SLOT       16

/* NFP cpu types */
#ifdef CONFIG_ONSTOR_BOBCAT
#define NFX_NFP_NUM_CPUS            4   /* on physical card */
#define NFX_NFP_TXRX1               0   /* for mgmt plane traffic */
#define NFX_NFP_TXRX2               1   /* for mgmt plane traffic */
#define NFX_NFP_FP1                 2   /* for mgmt plane traffic */
#define NFX_NFP_FP2                 3   /* for mgmt plane traffic */
#define NFX_NFP_TXRX_ANY            4   /* for data plane traffic */
#define NFX_NFP_FP_ANY              5   /* for data plane traffic */
#elif defined(CONFIG_ONSTOR_COUGAR)
#define NFX_NFP_NUM_CPUS            6   /* on physical card */
#define NFX_NFP_TXRX1               0   /* for mgmt plane traffic */
#define NFX_NFP_TXRX2               1   /* for mgmt plane traffic */
#define NFX_NFP_FP1                 2   /* for mgmt plane traffic */
#define NFX_NFP_FP2                 3   /* for mgmt plane traffic */
#define NFX_NFP_FP3                 4   /* for mgmt plane traffic */
#define NFX_NFP_FP4                 5   /* for mgmt plane traffic */
#define NFX_NFP_TXRX_ANY            6   /* for data plane traffic */
#define NFX_NFP_FP_ANY              7   /* for data plane traffic */
#endif

/*-----------------------------------------------------------------
 * Name:    EEE_GET_SLOT_NUM(dest_prot)
 *
 * Description: returns slot id from the dest_port word
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/19/01
 *
 *-----------------------------------------------------------------
 */
#define EEE_GET_SLOT_NUM(_dp) \
    (((_dp) & EDESC2_SLOT_MASK) >> EDESC2_SLOT_SHIFT)

/*-----------------------------------------------------------------
 * Name:    EEE_GET_DEST_CPU(dest_port)
 *
 * Description: returns major_id from the dest_port word
 *
 * Created by:  Rick Lund
 *
 * Date Created:    4/30/01
 *
 *-----------------------------------------------------------------
 */
#define EEE_GET_DEST_CPU(_dp) \
    (((_dp) & EDESC2_CPU_MASK) >> EDESC2_CPU_SHIFT)

/*-----------------------------------------------------------------
 * Name:    EEE_GET_APP_ID(dest_port)
 *
 * Description: returns the minor_id from the dest_port word
 *
 * Created by:  Rick Lund
 *
 * Date Created:    4/30/01
 *
 *-----------------------------------------------------------------
 */
#define EEE_GET_APP_ID(_dp) \
    (((_dp) & EDESC2_APP_MASK) >> EDESC2_APP_SHIFT)


#endif
