#ifndef __NETEEE_EEE_H
#define __NETEEE_EEE_H

struct eee_addr {
	uint8_t eee_bplane;
	uint8_t eee_slot;
	uint8_t eee_cpu;
	uint16_t eee_app;
};


struct sockaddr_eee {
	uint8_t seee_len;
	uint8_t seee_family;
	struct eee_addr seee_addr;
#define seee_bplane seee_addr.eee_bplane
#define seee_slot seee_addr.eee_slot
#define seee_cpu seee_addr.eee_cpu
#define seee_app seee_addr.eee_app
};

#define EEE_NULLAPP (0)
#define EEE_MAXSLOT EDESC2_SLOT_NUM
#define EEE_MAXCPU EDESC2_CPU_NUM
#define EEE_NULLSLOT (EEE_MAXSLOT - 2)
#define EEE_NULLCPU (EEE_MAXCPU - 2)
#define EEE_BROADSLOT (EEE_MAXSLOT - 1)
#define EEE_BROADCPU (EEE_MAXCPU - 1)
#define EEE_BROADBPLANE (EEE_MAXBACKPLANE + 1)

#define EEE_DATABPLANE 1
#define EEE_CONTROLBPLANE 2

/* relay header */
struct rl_hdr {
  uint16_t              rh_dtype;               /* device type of intf */
  uint16_t              rh_slot;                /* slot num of intf */
  uint16_t              rh_cpu;                 /* cpu num of intf */
  uint16_t              rh_link;                /* link num of intf */
  uint16_t              rh_ctrl;                /* ctrl flag for this pkt */
  uint16_t              rh_offset;              /* fragment offset */
  uint16_t              rh_pad;                 /* keep 16 bits aligned */
};

/* The relay application ID.
 */
#define EEE_RELAY_APP_ID 30

#define ONSTOR_PRIVATEIP_MAGIC 0x00abcdef

/* ONStor private ip's first two octets
 */
extern long onstor_private_ip_prefix;

/* Checks if an ip (struct in_addr) is an ONStor private IP address
 * in network byte order
 */
#define CHECK_ONSTOR_PRIVATE_IP(ip) (((ip).s_addr \
                                        & onstor_private_ip_prefix) \
                                            == onstor_private_ip_prefix)\

/* Checks if the ONStor magic Id is present in an sockaddr_in structure
 */
#define CHECK_ONSTOR_MAGIC(sin) \
  (*((u_int32_t *) &(sin)->sin_zero[4]) == ONSTOR_PRIVATEIP_MAGIC)

/* Retrieves the ONStor private IP from a sockaddr_in  structure
 * Assuming it is stored in host address format.
 */

#define ONSTOR_DECODE_PRIVATE_IP(sin) (*((u_int32_t *) &sin->sin_zero[0]))

#define onstor_set_private_ip(_sockaddr, _ip)  \
 {                                             \
        char    *_dst = (_sockaddr)->sin_zero; \
        if ((_ip)->s_addr) {                   \
        memcpy(_dst, (_ip), sizeof(*(_ip)));   \
                ((struct in_addr*)&_dst[4])->s_addr = ONSTOR_PRIVATEIP_MAGIC; \
        }                                      \
        else {                                 \
                bzero((_sockaddr)->sin_zero, sizeof((_sockaddr)->sin_zero));  \
        }                                      \
}

#define onstor_get_private_ip(_sockaddr, _ip)  \
{                                              \
        char    *_dst = &(_sockaddr)->sin_zero[0];                          \
        if (((struct in_addr*)&_dst[4])->s_addr != ONSTOR_PRIVATEIP_MAGIC)  \
                bzero((_ip), sizeof(*(_ip)));  \
        else                                   \
        memcpy((_ip), _dst, sizeof(*(_ip)));   \
}


#define onstor_bind_private_ip_to_sock(sock, raddr)   \
{                                                     \
        struct sockaddr_in  bindsin;                  \
        struct in_addr          privateIp;            \
        bzero(&bindsin, sizeof(bindsin));             \
                                                      \
        onstor_get_private_ip(raddr, &privateIp);     \
                                                      \
        if (privateIp.s_addr)   {                     \
            bzero(&bindsin, sizeof(bindsin));     \
            bindsin.sin_family = AF_INET;         \
            bindsin.sin_addr = privateIp;         \
                                                  \
        if (bind(sock, (struct sockaddr*)&bindsin, sizeof(bindsin)))    \
            fprintf(stderr,                                              \
            "onstor_bind_private_ip_to_sock: fail to bind to 0x%x (err %d)\n",\
            htonl(privateIp.s_addr), errno);      \
        }                                         \
}

#endif /* ifndef __NETEEE_EEE_H */
