/*
 *-----------------------------------------------------------------
 * Name:	eee-app.c
 * Description:	Application interface routines
 * Copyright (C) 2009, OnStor, Inc.
 *-----------------------------------------------------------------
 */
#include <linux/types.h>
#include <linux/socket.h>
#include <linux/kernel.h>
#include <linux/skbuff.h>

#include <linux/gfp.h>
#include <linux/slab.h>

#include "../tpl/nfx-defs.h"
#include "../tpl/nfx-types.h"
#include "../tpl/nfx-error.h"
#include "../tpl/eee-desc.h"

// #include "eee-api.h"
// #include "eee-ipc.h"
// #include "eee-app.h"
// #include "eee-attr.h"
// #include "eee-queue.h"
// #include "eee-fwd.h"
#include "eee-poll.h"
#include "eee-error.h"
// #include "eee-rq.h"
// #include "eee-mem.h"

#include "eee-app.h"
#define EEE_MAX_APP_CLIENTS 256

// This header defines the application ids and names. It's synchronized
// with the onstor.services addendum to /etc/services.

// #include "app_ids.h"

typedef struct app_trans {
        char *app_name;
        int32 app_id;
} app_trans_t;

app_trans_t app_trans_table[] = {};


/*-----------------------------------------------------------------
 * Name:	eee_allocateApplicationId
 *
 * Description:	An application that wants to receive packets from
 *		the EEE layer must allocate an application Id with
 *		this function and register a receive function to that
 *		appId in the following function.
 * Returns:     New applicationId, or EEE_ERR_INVALID_APP_NAME
 *-----------------------------------------------------------------
 */
int32
eee_allocateApplicationId(uchar8 *appName)
{
  uint32	i;

    if (appName) {
	for (i=0; ; i++) { 
		if (app_trans_table[i].app_id < 0)
			break;
		if (strcmp(app_trans_table[i].app_name, appName) == 0)
			return (app_trans_table[i].app_id);
	}
	printk("Invalid Application name, %s\n", appName);
	return EEE_ERR_INVALID_APP_NAME;
    } else { /* appName == NULL */
        return EEE_ERR_INVALID_APP_NAME;
    }
}
 
/*-----------------------------------------------------------------
 * Name:
 * Description:
 * Returns:    applicationId OR EEE_ERR_INVALID_APP_NAME
 *-----------------------------------------------------------------
 */
int32
eee_getApplicationId(uchar8 *appName)
{
	uint32	i;

	for (i=0; ; i++) { 
		if (app_trans_table[i].app_id < 0)
			break;
		if (strcmp(app_trans_table[i].app_name, appName) == 0)
			return (app_trans_table[i].app_id);
	}
	printk("Invalid Application name, %s\n", appName);
	return EEE_ERR_INVALID_APP_NAME;
}

/*-----------------------------------------------------------------
 * Name:
 * Description:
 *-----------------------------------------------------------------
 */
uchar8 *
eee_getAppNameFromId(int32 app_id)
{
	uint32	i;

	for (i=0; ; i++) {
		if (app_trans_table[i].app_id < 0)
			break;
		if (app_trans_table[i].app_id == app_id)
			return (app_trans_table[i].app_name);
	}
	return NULL;
}

/*-----------------------------------------------------------------
 * Name:	eee_registerReceiveFunc()
 *
 * Description:	To register a receive function which will be called
 *		when the EEE layer receives a packet destined for the
 *		indicated application Id.
 * Returns:     NFX_OK or EEE_ERR_APP_ALREADY_REGISTERED
 *-----------------------------------------------------------------
 */
int32
eee_registerReceiveFunc(int32 appId,
	void	(*rcv_func)(eee_descPtr_t edesc),
	void	(*mcast_rcv_func)(eee_descPtr_t edesc))
{
#ifdef LATER
	if (0 <= appId && appId < EEE_MAX_APP_CLIENTS) {

		if ((eee.rcv.uni[appId]) || (eee.rcv.multi[appId]))
			return EEE_ERR_APP_ALREADY_REGISTERED;
		eee.rcv.uni[appId]= rcv_func;
		eee.rcv.multi[appId] = mcast_rcv_func;
	} else {
		printk("eee_registerReceiveFunc: invalid application id %d\n", appId);
	}
#endif /* LATER */
	return NFX_OK;
}

/*-----------------------------------------------------------------
 * Name:	eee_unregisterReceiveFunc()
 * Description:	Remove function addresses attached to application Id
 *-----------------------------------------------------------------
 */
void
eee_unregisterReceiveFunc(int32	appId)
{
#ifdef LATER
	if (0 <= appId && appId < EEE_MAX_APP_CLIENTS) {
		eee.rcv.uni[appId] = NULL;
		eee.rcv.multi[appId] = NULL;
	} else {
		printk("eee_unregisterReceiveFunc: invalid application id %d\n", appId);
	}
#endif /* LATER */
}

/*-----------------------------------------------------------------
 * Name:	eee_registerCleanupRoutine()
 * Description:
 *-----------------------------------------------------------------
 */
int32
eee_registerCleanupRoutine(void	(*function_name)(eee_descPtr_t edesc))
{
#ifdef LATER
    int i;
    for (i = 0; (i < (EEE_MAX_FREE_ROUTINES - 1)); ++i) {
		if (!eee.free_routine[i]) {
			eee.free_routine[i] = function_name;
			return i+1;
		}
    }
    printk("Too many registered free routines\n");
#endif /* LATER */
    return 0;
}

/*-----------------------------------------------------------------
 * Name:
 * Description:
 *-----------------------------------------------------------------
 */
void
eee_appRx(eee_descPtr_t	edesc)
{
    enum eee_msg_type cmd = *(int32 *)edesc->bd[1].buf;
    eee_poll_cfg_rsp_t rsp[POLLCFG_RSP_MAX];
    uint32 halt_rsp = 0;

    switch (cmd) {

    case EEE_MSG_POLLCFG_SHOW:
        eee_pollCfgSSC(1, rsp, POLLCFG_RSP_MAX);
        eee_sendMessage(rsp, 
                        sizeof(rsp),
                        edesc->hdr.src_port, 
                        edesc->hdr.dest_port);
        break;

    case EEE_MSG_POLLCFG_SHOW_ALL:
        eee_pollCfgSSC(0, rsp, POLLCFG_RSP_MAX);
        eee_sendMessage(rsp, 
                        sizeof(rsp),
                        edesc->hdr.src_port, 
                        edesc->hdr.dest_port);
        break;

    case EEE_MSG_HALT:
        eee_halt_prepare();
        eee_sendMessage(&halt_rsp, 
                        sizeof(halt_rsp), 
                        edesc->hdr.src_port,
                        edesc->hdr.dest_port);
        eee_halt();
        break;

    default:
        printk("Invalid eee_appRx cmd, %d\n", cmd);
        break;
    }
    eee_freePacket(edesc);
    return;
}

