/*
 *-----------------------------------------------------------------
 *
 * Name:
 *
 * RCS:  $Id: eee-attr.h,v 1.9 2002/11/07 01:20:03 rick Exp $
 *
 * Copyright (C) 2002, Agile Storage, Inc.
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	8/5/02
 *
 *-----------------------------------------------------------------
 */

#ifndef _EEE_ATTR_H
#define _EEE_ATTR_H

#define EEE_ATTR_MAX	32

typedef struct _eee_attr {
	uint32	index;
	byte	cpu_id[EEE_ATTR_MAX];
	byte	attr[EEE_ATTR_MAX];
	byte	free_valid[4];
} eee_attr_t;

#define EEE_ATTR_ALLOCATE		255
#define EEE_ATTR_FREE			254
#define EEE_ATTR_FREE_PKT		253
#define EEE_ATTR_RQ_ENQUEUE		252
#define EEE_ATTR_RQ_DEQUEUE		251
#define EEE_ATTR_FWD			250
#define EEE_ATTR_FWD_TO_FREE	249

#define EEE_ATTR_SAC_COD_LUC		240
#define EEE_ATTR_SAC_COD_SNIM		239
#define EEE_ATTR_SAC_COD_CREATE		238
#define EEE_ATTR_SAC_COD_MERGE		237
#define EEE_ATTR_SAC_COD_SPLIT_SRC	236
#define EEE_ATTR_SAC_COD_SPLIT_DEST	235
#define EEE_ATTR_SAC_COD_FREE_OK	234

#define EEE_ATTR_LUC_RX             230
#define EEE_ATTR_LUC_ALLOC          229

#define EEE_ATTR_MAC_RX             200
#define EEE_ATTR_MAC_TX             199

#define EEE_ATTR_CONV_ALLOC         190
#define EEE_ATTR_CONV_FREE          189

#define EEE_ATTR_83820_RX           180
#define EEE_ATTR_83820_TX           179
#define EEE_ATTR_83820_FREE         178

#ifdef EEE_ATTR
/*------------------------------------------------------------------*/
void
eee_attrInit();

/*------------------------------------------------------------------*/
eee_attr_t *
eee_attrGetDescAttrPtr(
    eee_descPtr_t   addr
);

/*------------------------------------------------------------------*/
eee_attr_t *
eee_attrGetBufAttrPtr(
    address_t   addr
);

/*------------------------------------------------------------------*/
eee_attr_t *
eee_attrGetAttrPtr(
    address_t   addr
);

/*------------------------------------------------------------------*/
void
eee_attrDisplayConfig();

/*------------------------------------------------------------------*/
void
eee_attrDisplay(address_t addr);

/*------------------------------------------------------------------*/
void
eee_attrAssignPkt(
	eee_descPtr_t	edesc,
	byte			attr
);

/*------------------------------------------------------------------*/
void
eee_attrAssignDesc(
	eee_descPtr_t	edesc,
	byte			attr
);

/*------------------------------------------------------------------*/
void
eee_attrAssignBuf(
	void	* buf,
	byte	attr
);

/*------------------------------------------------------------------*/
int32
eee_attrOkToFreeDesc(
	eee_descPtr_t	desc
);

/*------------------------------------------------------------------*/
int32
eee_attrOkToFreeBuf(
	void	* buf
);

/*------------------------------------------------------------------*/
void
eee_attrSetPktValidFreeAttr(
	eee_descPtr_t	edesc,
	byte			attr0,
	byte			attr1,
	byte			attr2,
	byte			attr3
);

/*------------------------------------------------------------------*/
void
eee_attrSetDescValidFreeAttr(
	eee_descPtr_t	edesc,
	byte			attr0,
	byte			attr1,
	byte			attr2,
	byte			attr3
);
void
eee_attrGetDescValidFreeAttr(
	eee_descPtr_t	edesc,
	byte			* attr0,
	byte			* attr1,
	byte			* attr2,
	byte			* attr3
);

/*------------------------------------------------------------------*/
void
eee_attrSetBufValidFreeAttr(
	void	* buf,
	byte	attr0,
	byte	attr1,
	byte	attr2,
	byte	attr3
);
void
eee_attrGetBufValidFreeAttr(
	void	* buf,
	byte	* attr0,
	byte	* attr1,
	byte	* attr2,
	byte	* attr3
);

/*------------------------------------------------------------------*/
byte
eee_attrGetDescLastAttr(
	eee_descPtr_t	edesc
);

/*------------------------------------------------------------------*/
byte
eee_attrGetBufLastAttr(
	void	* buf
);

/*------------------------------------------------------------------*/
void
eee_attrShowDescAll();

/*------------------------------------------------------------------*/
void
eee_attrShowBufAll();

#else

#define eee_attrAssignPkt(edesc, attr);

#define eee_attrAssignDesc(edesc, attr);
#define eee_attrAssignBuf(buf, attr);
#define eee_attrSetPktValidFreeAttr(edesc, attr0, attr1, attr2, attr3);

#define eee_attrSetDescValidFreeAttr(edesc, attr0, attr1, attr2, attr3);
#define eee_attrGetDescValidFreeAttr(edesc, attr0, attr1, attr2, attr3);

#define eee_attrSetBufValidFreeAttr(buf, attr0, attr1, attr2, attr3);
#define eee_attrGetBufValidFreeAttr(buf, attr0, attr1, attr2, attr3);

#define eee_attrGetDescLastAttr(edesc)	(0)
#define eee_attrGetBufLastAttr(buf)		(0)

#endif	/* EEE_ATTR */

#endif	/* _EEE_ATTR_H */

