/*
 *-----------------------------------------------------------------
 *
 * Name:	eee-drv.c
 *
 * RCS:  $Id: eee-drv.c,v 1.6 2002/11/07 01:20:03 rick Exp $
 *
 * Copyright (C) 2001, Agile Storage Inc.
 *
 * Description:	Driver interface routines
 *
 * Created by:	Rick Lund
 *
 * Date Created:	4/10/01
 *
 *-----------------------------------------------------------------
 */

#include "nfx-incl.h"
#include "../sm-eee/eee-api.h"
#ifdef DMALLOC
#include "dmalloc.h"
#endif

eee_rcv_t	eee_rcv;

/*-----------------------------------------------------------------
 * Name:	eee_registerTransmitFunc()
 *
 * Description:	Drivers will use this routine to register their
 *				transmit functions with the EEE layer
 *
 * Created by:	Rick Lund
 *
 * Date Created:	4/9/01
 *
 *-----------------------------------------------------------------
 */
int32						/* NFX_OK,
							 * EEE_ERR_DRV_ALREADY_REGISTERED,
							 * EEE_ERR_BAD_PARAM,
							 */
eee_registerTransmitFunc(
	uint32	port_id,		/* major id - from well-known major id table */
	eee_transmitFunc_t xmit_unicast,		/* unicast transmit function */
	eee_transmitFunc_t xmit_multicast,		/* multicast transmit function */
	int mtu									/* Maximum packet length excluding
											   link level header */
)
{
	NFX_ASSERT(0 < mtu && 0 <= 0xFFFF);

	if (port_id >= EDESC2_PORT_NUM)
		return EEE_ERR_BAD_PARAM;

#ifndef DIAG_R7000	
	if ((eee.drv.uni[port_id].func) || (eee.drv.multi[port_id].func))
		return EEE_ERR_DRV_ALREADY_REGISTERED;
#endif
	eee.drv.uni[port_id].func			= xmit_unicast;
	eee.drv.uni[port_id].forwarded		= 0;
	eee.drv.uni[port_id].dropped		= 0;
	eee.drv.uni[port_id].mtu 			= mtu;
	eee.drv.multi[port_id].func			= xmit_multicast;
	eee.drv.multi[port_id].forwarded	= 0;
	eee.drv.multi[port_id].dropped		= 0;
	eee.drv.multi[port_id].mtu			= mtu;
	eee.drv.no_uni						= 0;
	eee.drv.no_multi					= 0;

	return NFX_OK;

}	/* eee_registerTransmitFunc() */

/*-----------------------------------------------------------------
 * Name:	eee_registerDefaultTransmitFunc()
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	11/10/01
 *
 *-----------------------------------------------------------------
 */
int32						/* NFX_OK,
							 * EEE_ERR_DRV_ALREADY_REGISTERED,
							 * EEE_ERR_BAD_PARAM,
							 */
eee_registerDefaultTransmitFunc(
	uint32	data_type,
	eee_transmitFunc_t   xmit_unicast,			/* unicast transmit function */
	int mtu										/* Maximum packet length excluding
												   link level header */
)
{
	NFX_ASSERT(0 < mtu && mtu <= 0xFFFF);

	if (data_type >= EDESC2_DATA_TYPE_NUM)
		return EEE_ERR_BAD_PARAM;

	eee.drv.dtype_default[data_type].func			= xmit_unicast;
	eee.drv.dtype_default[data_type].forwarded	= 0;
	eee.drv.dtype_default[data_type].dropped		= 0;
	eee.drv.dtype_default[data_type].mtu = mtu;

	return NFX_OK;

}	/* eee_registerDefaultTransmitFunc() */

/*-----------------------------------------------------------------
 * Name:	eee_unregisterTransmitFunc()
 *
 * Description:	Remove registered transmit function from driver
 *
 * Created by:	Rick Lund
 *
 * Date Created:	4/9/01
 *
 *-----------------------------------------------------------------
 */
int32						/* NFX_OK,
							 * EEE_ERR_DRV_NOT_REGISTERED
							 * EEE_ERR_BAD_PARAM
							 */
eee_unregisterTransmitFunc(
	uint32	port_id unused__			/* major id - from well-known major id table */
)
{

	panic("unimplemented\n");

	return NFX_OK;

}	/* eee_unregisterTransmitFunc() */

