/*
 *-----------------------------------------------------------------
 *
 * Name:	eee-drv.h
 *
 * Copyright (C) 2009, Onstor
 *
 * Description:	Driver Interface definitions
 *
 * Date Created:	4/9/01
 *
 *-----------------------------------------------------------------
 */

#ifndef _EEE_DRV_H
#define _EEE_DRV_H

#define EEE_USER_DATA			0
#define EEE_CONTROL				1
#define EEE_MGMT				2
#define EEE_JOURNAL				3
#define EEE_METADATA			4
#define EEE_SAC					5
#define EEE_ALL_DTYPES			6

#define EEE_FORWARDED_PACKET	0			/* packet was transmitted */
#define EEE_DROP_PACKET			1			/* EEE should drop packet */
#define EEE_TX_QUEUE_FULL		2			/* packet could not be added to
											 * transmit queue due to a full
											 * condition - sender should
											 * decide what to do with packet.
											 */

struct edesc;

/* Transmit functions type */
typedef int32 (*eee_transmitFunc_t)(uint32 dest_port, struct edesc *edesc);
	

/*-----------------------------------------------------------------
 * Name:	eee_registerTransmitFunc()
 *
 * Description:	Drivers will use this routine to register their
 *				transmit functions with the EEE layer
 *
 * Created by:	Rick Lund
 *
 * Date Created:	4/9/01
 *
 *-----------------------------------------------------------------
 */
int32						/* NFX_OK,
							 * EEE_ERR_DRV_ALREADY_REGISTERED,
							 * EEE_ERR_BAD_PARAM,
							 */
eee_registerTransmitFunc(
	uint32	port_id,						/* port id - from nfx-defs.h */
	eee_transmitFunc_t xmit_unicast,		/* unicast transmit function */
	eee_transmitFunc_t xmit_multicast,		/* multicast transmit function */
	int mtu									/* Maximum packet length excluding
											   link level header */
);

/*-----------------------------------------------------------------
 * Name:	eee_registerDefaultTransmitFunc()
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:	11/10/01
 *
 *-----------------------------------------------------------------
 */
int32						/* NFX_OK,
							 * EEE_ERR_BAD_PARAM,
							 */
eee_registerDefaultTransmitFunc(
	uint32	data_type,
	eee_transmitFunc_t   xmit_unicast,			/* unicast transmit function */
	int mtu										/* Maximum packet length excluding
												   link level header */
);
/*-----------------------------------------------------------------
 * Name:	eee_unregisterTransmitFunc()
 *
 * Description:	Remove registered transmit function from driver
 *
 * Created by:	Rick Lund
 *
 * Date Created:	4/9/01
 *
 *-----------------------------------------------------------------
 */
int32						/* NFX_OK,
							 * EEE_ERR_DRV_NOT_REGISTERED
							 * EEE_ERR_BAD_PARAM
							 */
eee_unregisterTransmitFunc(
	uint32	port_id			/* port id - from nfx-defs.h */
);

#endif	/* _EEE_DRV_H */
