/*
 *-----------------------------------------------------------------
 *
 * Name:	eee-init.c
 *
 * RCS:  $Id: eee-init.c,v 1.35 2002/12/07 00:02:01 rick Exp $
 *
 * Copyright (C) 2001, Agile Storage Inc.
 *
 * Description:	EEE Layer initialization functions
 *
 * Created by:	Rick Lund
 *
 * Date Created:	4/10/01
 *
 *-----------------------------------------------------------------
 */

#include "nfx-incl.h"
#include "../sm-eee/eee-api.h"
#if defined(SSC) || defined(SSC_MGMT) || defined(FCNIM)
#include "../sm-malloc/malloc-api.h"
#else
#include "../sm-malloc-slab/malloc-api.h"
#endif
#include "../sm-hw/pte-api.h"
#include "../sm-chassis/cm-api.h"

#include "../sm-trace/trace.h"
#ifdef DMALLOC
#include "dmalloc.h"
#endif

eee_config_t	eee;

eee_stats_t		* eee_stats;

#ifdef EEE_VALIDATE
eee_validate_t	* eee_desc_validate[2];
eee_validate_t	* eee_buf_validate[2][EEE_NUM_BUF_SIZES];
#endif

uchar8	* eee_sm_prom_upgrade;
extern uint32	dont_poll;

address_t	stack_addr CPU_PRIVATE;
#ifndef NFX_SMP
uchar8	stack[STKSIZE];
#endif

#ifdef DEBUG
/* Include in memory circular trace.
 */

/* This is the number of trace entries.
 */
#define  TTRACE_SIZE 2000

/* Pointer to the trace structure.
 */
#if defined(NFX_SMP)
trc_EmbeddedTrace_t * tracePtr = NULL;
#else
trc_EmbeddedTrace_t * tracePtr CPU_PRIVATE = NULL;
#endif
#endif

extern void eee_initFixedFwdQueues(void);
extern void fs_rpc_alloc_memory(void);

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:    8/23/02
 *
 *-----------------------------------------------------------------
 */
void
eee_initSync(
	uint32  val
)
{
#if defined(NFP_FP) || defined(NFP_TXRX)
	volatile uint32 * shmem_ptr;

	watchdog_kick();

#ifdef NFP_FP
	shmem_ptr = ((volatile uint32 *)
                 PHYS_TO_XKSEG_UNCACHED(0x1000 | HW_HT_REMOTE_BASE_ADDRESS));
	while (*shmem_ptr != val);
	*shmem_ptr = 0;
	*(shmem_ptr+4) = val+1;
#endif

#ifdef NFP_TXRX
    shmem_ptr = ((volatile uint32 *)
                 PHYS_TO_XKSEG_CACHED(0x1000 | HW_HT_LOCAL_BASE_ADDRESS));
	*shmem_ptr = val;
	while (*(shmem_ptr+4) != (val+1));
	*(shmem_ptr+4) = 0;
#endif

#endif
}

void *
eee_mgmtAlloc(uint32 num_bytes);

/*-----------------------------------------------------------------
 * Name:	eee_init(uint32 pass)
 *
 * Description:	EEE layer init function
 *
 * Created by:	Rick Lund
 *
 * Date Created:	4/10/01
 *
 *-----------------------------------------------------------------
 */

void
eee_init(
	uint32	pass
)
{
	int32	eee_app_id;

	if (pass == 1) {
		EEE_PRINTF(("[eee_init]:pass 1\n"));
		eee_stats = &(eee.stats);

		NFX_SPIN_INIT(&eee.bufpool_spin, SPINLOCK_LEVEL_UNKNOWN);
		NFX_SPIN_INIT(&eee.descpool_spin, SPINLOCK_LEVEL_UNKNOWN);

		eee_shmemGetSharedMemoryPools();

		eee.my_pool_id = eee_platGetMyPoolId();
		eee.my_fwd_id = eee_platGetMyFwdId();

		eee.sm_size = eee_platGetSharedMemorySize();

		eee.buf_size[EEE_BUF_SMALL] = EEE_BUFSIZE_SMALL;
		eee.buf_size[EEE_BUF_LARGE] = EEE_BUFSIZE_LARGE;
		eee.buf_size[EEE_BUF_ULTRA] = EEE_BUFSIZE_ULTRA;
#ifdef EEE_BUF_MGMT
		eee.buf_size[EEE_BUF_MGMT] = EEE_BUFSIZE_MGMT;
#endif

		eee.buf_mask[EEE_BUF_SMALL] = ~(EEE_BUFSIZE_SMALL-1);
		eee.buf_mask[EEE_BUF_LARGE] = 0;		/* N/A, since not aligned */
		eee.buf_mask[EEE_BUF_ULTRA] = 0;		/* N/A, since not aligned */
#ifdef EEE_BUF_MGMT
		eee.buf_mask[EEE_BUF_MGMT] = 0;
#endif

#ifdef EEE_BUF_MGMT
		/*
		 * Allocate shared memory space for accesses from PCI to memory on Sibyte
		 * This should be first memory allocated, so that it's guaranteed to
		 * be aligned on nice MB boundary (needed for PCI BAR0 setup).
		 */
#if defined(NFP_TXRX)
		eee.mgmt_size_buf = 0x700000;
		eee.mgmt_size_cont = 0x100000;
#elif defined(NFP_FP)
        eee.mgmt_size_buf = 0x0;
        eee.mgmt_size_cont = ((sizeof(struct rcon_queue) * SMP_MAX_CPUS) +
                              ((8 * 1024) - 1)) & ~((8 * 1024) - 1);
#else
		eee.mgmt_size_buf = 0;
		eee.mgmt_size_cont = 0;
#endif
		eee.mgmt_stack_size = (eee.mgmt_size_buf/eee.buf_size[EEE_BUF_MGMT]) *
															sizeof(address_t);
#else
		eee.mgmt_stack_size = 0;
#endif

		eee_memInit(1);

#ifdef NFP_FP
		/*
		 * Allocate memory in FP's shared memory for memory region descriptors
		 * to be used by coredump feature, so that the FP can dump all
		 * appropriate TXRX memory regions.
		 */
		if (nfxMyCoreId == 0)
			memRec = (memDesc_t *)eee_allocateBlock(sizeof(memDesc_t) * 2);
#elif NFP_TXRX
		memRec = (memDesc_t *)REMOTE_MEM;
#endif

        if ((eee.mgmt_size_buf + eee.mgmt_size_cont) > 0) {
            eee.mgmt_space = 
                (address_t)eee_allocateBlock(eee.mgmt_size_buf + 
                                             eee.mgmt_size_cont);

            eee_memInit(2);

#if defined(NFP_TXRX) || defined(NFP_FP)
            eee.rcon_queues =
                eee_mgmtAlloc(sizeof(struct rcon_queue) * SMP_MAX_CPUS);
            if (eee.rcon_queues == NULL) {
                panic("%s: cannot allocate rcon queue memory\n", 
                      __FUNCTION__);
            }
#endif            
        }

		eee.wka = eee_platGetWKA();

		/*
		 * Application Ids
 		 */
		eee.app_id = eee_allocateApplicationId("eee");
		eee.simple_test_app_id = eee_allocateApplicationId("eee_test_simple");
		eee.dvt_test_app_id = eee_allocateApplicationId("eee_test_complex");
		eee.anp_test_app_id = eee_allocateApplicationId("eee_anp_test");

#if defined(NFP_FP) || defined(NFP_TXRX)
        fs_rpc_alloc_memory();
#endif

		/*
		 * Drivers can now allocate their shared memory as needed
		 */

/*
		if (isTXRX())
			eee_sm_prom_upgrade = eee_allocateBlock(0x80000);
*/
#ifdef DEBUG
		tracePtr = trc_embeddedTraceInit(TTRACE_SIZE);
#endif
	}
	else if (pass == 2) {
#if (EEE_NUM_SM_POOLS > 1)
		int32	rc;
#endif
		uint32	i;
		EEE_PRINTF(("[eee_init]:pass 2\n"));
#if (EEE_NUM_IPC_QUEUES > 0)
		eee_initIPCQueues();
#endif	/* EEE_NUM_IPC_QUEUES > 0 */

#if (EEE_NUM_SM_POOLS > 0)
#ifndef EEE_NEW_RATIO
		eee.bytes_per_small_buf = (EEE_BUFSIZE_SMALL +
							((EEE_BUFSIZE_LARGE * SMALL_TO_LARGE_RATIO)/8) +
							((EEE_BUFSIZE_ULTRA * SMALL_TO_ULTRA_RATIO)/8) +
							((sizeof(eee_desc_t) * DESC_TO_SMALL_RATIO)/8) +
							((sizeof(long)* FWD_TO_SMALL_RATIO)/8) +
							((sizeof(long) * (8+
												SMALL_TO_LARGE_RATIO+
												SMALL_TO_ULTRA_RATIO+
												DESC_TO_SMALL_RATIO))/8)
#ifdef EEE_ATTR
							+ ((sizeof(eee_attr_t) * (8 +
												SMALL_TO_LARGE_RATIO+
												SMALL_TO_ULTRA_RATIO+
												DESC_TO_SMALL_RATIO))/8)
#endif

							);
#endif	/* !EEE_NEW_RATIO */

#if (EEE_NUM_SM_POOLS > 1)
		eee_initSharedDescRQ(1);		/* init RQ */
		eee_initSharedBufsRQ(1);		/* init RQ */

		eee_initAllocateTailPtrs();
#endif	/* EEE_NUM_SM_POOLS > 1 */

#if (EEE_NUM_FIXED_FWD_QUEUES > 0)
        eee_initFixedFwdQueues();
#endif        

		/*
		 * After this point, only descriptors and buffers can be
		 * allocated from shared memory.
		 */
/*
 *
 * HACK HACK HACK
 *
 *
 */
#ifdef EEE_NEW_RATIO
		eee.num_alloc_pages = (eee_remainBytes()-eee.mgmt_stack_size - 
                               EEE_STACK_POOL_RESERVE) / ALLOC_DIVISOR;
#else
		eee.sm_for_desc_and_buf = eee_remainBytes() - 0x110000;
#endif

		for (i=0; i<EEE_NUM_BUF_SIZES; i++) {
			eee.sm_num_buf[i] = eee_platGetNumSharedBuffers(i);
			eee_stats->low_watermark_buf[eee.my_pool_id - SHARED_POOL_OFFSET][i]
														= eee.sm_num_buf[i];
		}
		eee_platAdjustNumSharedBuffers();
	
		eee.sm_num_desc = eee_platGetNumSharedDesc();
		eee_stats->low_watermark_desc[eee.my_pool_id - SHARED_POOL_OFFSET] =
															eee.sm_num_desc;
		eee.sm_num_fwd = eee_platGetNumSharedFwd();

#ifdef EEE_VALIDATE
		eee_desc_validate[1] = eee_ramAllocZero(eee.sm_num_desc *
													sizeof(eee_validate_t));
#endif

#if (EEE_NUM_FWD_QUEUES > 0)
		eee_initFWDQueues();
#endif	/* EEE_NUM_FWD_QUEUES > 0 */

#ifdef EEE_ATTR
		eee_attrInit();
#endif

		eee_initDeallocateSharedDesc(0);
		eee_initDeallocateSharedBuffers(0);

#ifdef EEE_VALIDATE
		for (i=0; i<EEE_NUM_BUF_SIZES; i++) {
			if (eee.sm_num_buf[i])
				eee_buf_validate[1][i] = eee_ramAllocZero(eee.sm_num_buf[i] *
													sizeof(eee_validate_t));
		}
#endif

		eee_initSharedDescRQ(2);		/* init shared pool for self */
		eee_initSharedBufsRQ(2);		/* init shared pool for self */

#if (EEE_NUM_SM_POOLS > 1)
		if ((rc = eee_initPutSharedMemAddrsToOtherCPUs()) != NFX_OK) {
			printf("Failed to store RQ addr in shared memory, rc = 0x%x\n", rc);
		}

		if ((rc = eee_initGetSharedMemAddrsFromOtherCPUs()) != NFX_OK) {
			printf("Failed to get Shared Memory addresses, rc = 0x%x\n", rc);
		}

		eee_initGetTailPointers();
		eee_initTailPointers();

		eee_initSync(0x12345678);

        printf("Zeroing the WKA area, %p\n", (void *)eee.wka);
        bzero((void *)eee.wka, 0x100000);

#endif	/* EEE_NUM_SM_POOLS > 1 */

		eee_initDeallocateSharedDesc(1);
		eee_initDeallocateSharedBuffers(1);

#endif	/* EEE_NUM_SM_POOLS > 0 */

		EEE_PRINTF(("Shared Memory remain = %d bytes\n", eee_remainBytes()));

/*
		eee_initLocalDesc();
		eee_initLocalBufs();
*/
		dont_poll = 0;
		eee.init_done = 1;

#if 0
		eee_displayDescQueues(0);
		eee_displayDescQueues(1);
		eee_displayBufQueues(0);
		eee_displayBufQueues(1);
		eee_displayIPCQueues(0);
		eee_displayIPCQueues(1);
		eee_displayFWDQueues(0);
		eee_displayFWDQueues(1);
#endif

#if (EEE_NUM_SM_POOLS > 1)
		eee_rqInit();
#endif

		eee_fwdInit();

		eee_testInit();

#if (EEE_NUM_SM_POOLS > 1)
#if defined(NFP_TXRX) || defined(NFP_FP)
		eee_initSync(0xabcdef01);

		{
		uint32	i;
		for (i=0; i<100; i++)
		eee_rqResupply((void *)1, 0);
		}

		eee_initSync(0x01020344);
#endif
#endif

		eee_app_id = eee_allocateApplicationId("eee");
		eee_registerReceiveFunc(eee_app_id, eee_appRx, eee_appRx);

	}

}	/* eee_init() */



