/*
 *-----------------------------------------------------------------
 *
 * Name:	eee-ipc.h
 *
 * Copyright (C) 2009, Onstor
 *
 * Description:	Definitions and typedefs for IPC messaging.
 *
 * Date Created:	4/9/01
 *
 *-----------------------------------------------------------------
 */

#ifndef _EEE_IPC_H
#define _EEE_IPC_H

typedef struct ipc_client {
#if !defined(_KERNEL_)
	int32	(*func)();
#endif
	uint32	msgs_rcvd;
} ipc_client_t;

/*
 * EEE IPC commands
 */
#define EEE_IPC_CMD_SYNC		0x1

/*
 * CPU identifiers for sendIPC()
 */
#define IPC_NIM_TX		1	/* on GbE NIM, CPU handling network transmit */
#define IPC_NIM_RX		2	/* on GbE NIM, CPU handling network receive */
#define IPC_FP1			3	/* on GbE NIM, one of the two FSP CPUs */
#define IPC_FP2			4	/* on GbE NIM, other of the two FSP CPUs */

#define IPC_SSC			6	/* on SSC, the main CPU, running LINUX */
#define IPC_SSC_MGMT	7	/* on SSC, the management CPU */

#ifdef NFX_MOD_NFP
#define GET_IPC_Q_INDEX(_d_cpu)					\
({												\
	int32	_r;									\
												\
	if (_d_cpu == IPC_NIM_TX)					\
		_r = 0;									\
	else if (_d_cpu == IPC_NIM_RX)				\
		_r = 1;									\
	else if (_d_cpu == IPC_FP1)					\
		_r = 2;									\
	else if (_d_cpu == IPC_FP2)					\
		_r = 3;									\
	else										\
		_r = -1;								\
	_r;											\
})
#endif
#ifdef NFX_MOD_SSC
#define GET_IPC_Q_INDEX(_d_cpu)					\
({												\
	int32	_r;									\
												\
	if (_d_cpu == IPC_SSC)						\
		_r = 0;									\
	else if (_d_cpu == IPC_SSC_MGMT)			\
		_r = 1;									\
	else										\
		_r = -1;								\
	_r;											\
})
#endif

/*
 * IPC Clients
 */
#define EEE_IPC_NUM_CLIENTS		3

#define IPC_CLIENT_EEE			0		/* EEE layer */
#define IPC_CLINET_EVENT_MGR	1		/* event manager */
#define IPC_CLIENT_CM			2		/* chassis manager */


#define EEE_IPC_NUM_ENTRIES		64		/* entries per queue */

#define EEE_IPC_ENTRY_SIZE		512
#define EEE_IPC_DATA_SIZE_MAX	(EEE_IPC_ENTRY_SIZE-3)	/* in words */

/*------------------------------------------------------------------*/
/*
 * Each entry in an IPC queue will have the following format
 */
typedef struct ipc_ent {
	uint32	control;
#define IPC_CONT_OWN			0x80000000
#define IPC_CONT_ACK_REQ		0x40000000
#define IPC_CONT_RESP_ACK		0x20000000
#define IPC_CONT_RESP_NACK		0x10000000
#define IPC_CONT_SIZE_MASK		0x0000FFFF
	uint32	client_id;
	uint32	command;
	uint32	msg[EEE_IPC_DATA_SIZE_MAX];
} eee_ipcEntry_t;

/*-----------------------------------------------------------------
 * Name:    eee_initIPCQueues()
 *
 * Description: allocate memory for IPC messaging queues
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/7/01
 *
 *-----------------------------------------------------------------
 */
void
eee_initIPCQueues(void);

/*-----------------------------------------------------------------
 * Name:	eee_registerIPCClient(client_id, rcv_func)
 *
 * Description:	To receive IPC messages, client must register an IPC
 *				receive function.
 *
 * Created by:	Rick Lund
 *
 * Date Created:	4/9/01
 *
 *-----------------------------------------------------------------
 */
int32					/*	NFX_OK,
						 *	EEE_ERR_IPC_BAD_CLIENT,
						 *	EEE_ERR_IPC_ACK_TIMED_OUT
						 */
eee_registerIPCClient(
	uint32	client_id,				/* from client_id table */
	int32	(*ipc_rcv_func)(		/* function to be called when an IPC
									 * for this client_id is received
									 */
				uint32	ipc_command,		/* from sender's sendIPC call */
				uint32	data_size,			/* number of valid IPC bytes */
				uint32	*ipc_data,			/* IPC data */
				uint32	*ipc_response,		/* response from receiver */
				uint32	*ipc_response_data_size,	/* size of IPC response */
				uint32	**ipc_response_data			/* IPC response data */
			)
);

#define IPC_WAIT_FOR_SPACE_COUNT	0x1000000
#define IPC_WAIT_FOR_ACK_COUNT		0x10000000

/*-----------------------------------------------------------------
 * Name:	eee_sendIPC()
 *
 * Description:	To send an IPC message
 *
 * Created by:	Rick Lund
 *
 * Date Created:	4/9/01
 *
 *-----------------------------------------------------------------
 */
int32
eee_sendIPC(
	uint32	dest_cpu,		/* IPC_NIM_RX, IPC_NIM_TX,
							 * IPC_FP1, IPC_FP2,
							 */
	uint32	client_id,		/* from client_id table */
	uint32	control,
#define IPC_ACK_REQ		0x00000001
	uint32	command,		/* command to be sent to receive function */
	uint32	data_size,		/* num bytes of valid buffer data */
	uint32	*ipc_data,		/* local buffer containing IPC message */
	uint32	*ipc_response,				/* if desired, area for the response */
	uint32	*ipc_response_data_size,	/* if desired, area for size of
										 * response message
										 */
	uint32	**ipc_response_data			/* if desired, buffer for response
										 * data
										 */
);

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
void
eee_checkIPCQueues(
	void	* cb,
	uint32	tref
);

/*-----------------------------------------------------------------
 * Name:    eee_showIPCStats()
 *
 * Description: Display counts for messages to IPC clients
 *
 * Created by:  Rick Lund
 *
 * Date Created:    5/21/01
 *
 *-----------------------------------------------------------------
 */
void
eee_showIPCStats(void);

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:  Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
void
eee_ipcInit(void);

#endif	/* _EEE_IPC_H */

