/*
 *-----------------------------------------------------------------
 *
 * Name:	eee-mem.h
 *
 * RCS:  $Id: eee-mem.h,v 1.3 2002/11/13 01:14:33 maximk Exp $
 *
 * Copyright (C) 2002, Agile Storage, Inc.
 *
 * Description:	Memory initialization and allocation routines for
 *				EEE layer.  These are NOT the routines for general
 *				memory management of the heap (malloc(), dealloc())!
 *
 * Created by:	Rick Lund
 *
 * Date Created:	5/4/01
 *
 *-----------------------------------------------------------------
 */

#ifndef _EEE_MEM_H
#define _EEE_MEM_H

extern rq_sizes_t	rq_size[];
extern uint32		fwd_size[];

#define ALIGN_SIZE		32
#define ALIGN_SHIFT		5			/* bits in ALIGN_SIZE bytes */

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
void
eee_memInit(
    uint32  pass
);

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
uint32
eee_remainBytes(void);

/*-----------------------------------------------------------------
 * Name:	eee_allocateBlock(uint32 num_bytes)
 *
 * Description:	allocates a block of memory aligned on cacheline
 *				boundary.
 *				This function should be used at init time (by drivers, etc)
 *				to preallocate a piece of memory.  The caller should assume
 *				that this memory is NOT being allocated from a
 *				shared-between-CPUs pool.
 *
 * Created by:	Rick Lund
 *
 * Date Created:	5/4/01
 *
 *-----------------------------------------------------------------
 */
void *					/* returns memory base address, or NULL */
eee_allocateBlock(
	uint32	num_bytes
);

/*-----------------------------------------------------------------
 * Name:	eee_allocateAlignedBlock(uint32 num_bytes)
 *
 * Description:	allocates a block of memory aligned according to
 *				the size requested (2 KB bytes, aligned on 2 KB byte
 *				boundary).
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */

void *					/* returns memory base address, or NULL */
eee_allocateAlignedBlock(
	uint32	num_bytes
);

#endif	/* _EEE_MEM_H */

