/*
 *-----------------------------------------------------------------
 * Name:	eee-platform.c
 * Copyright (C) 2001, Agile Storage, Inc.
 *
 * Description:
 *-----------------------------------------------------------------
 */
#include "nfx-incl.h"
#include "../sm-hw/hwMap.h"
#include "../sm-eee/eee-api.h"
#include "../sm-chassis/cm-api.h"
#include "../sm-hw/pte-api.h"
#include "../sm-hw/mem-api.h"
#include "sys/mips.h"
#include "eee-shmem.h"

#ifdef LINUX_TEST
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#ifdef DMALLOC
#include "dmalloc.h"
#endif
#endif

/*-----------------------------------------------------------------
 * Name:	eee_shmemGetSharedMemoryPools()
 *
 * Description: Initialize shmem_base
 *
 *	For LINUX_TEST:	Attach to shared memory segments allocated from the SHMEM Image
 *-----------------------------------------------------------------
 */
int32
eee_shmemGetSharedMemoryPools()
{
	uint32	size;

#ifdef LINUX_TEST
	int32	shmid;
	uchar8	* shmptr;

/*
 *
 * NFP CPUs
 *
 */
	if ((shmid = shmget(SHM_SEG_TXRX, 0, SHM_R | SHM_W)) < 0) {
		printf("error in shmget, shmid = 0x%x\n", shmid);
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}
	if ((shmptr = (uchar8 *)shmat(shmid, (void *)0x30000000, 0)) == (void *) -1) {
		printf("shmat error\n");
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}

	printf("TXRX : PSM base at 0x%x\n", shmptr);

#ifdef NFP_TXRX
	eee.shmem_base = (uint32)shmptr;
#endif

	if ((shmid = shmget(SHM_SEG_FP, 0, SHM_R | SHM_W)) < 0) {
		printf("error in shmget, shmid = 0x%x\n", shmid);
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}
	if ((shmptr = (uchar8 *)shmat(shmid, (void *)0x31000000, 0)) == (void *) -1) {
		printf("shmat error\n");
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}

	printf("FP : PSM base at 0x%x\n", shmptr);

#ifdef NFP_FP
	eee.shmem_base = shmptr;
#endif

/*
 *
 * SSC CPUs
 *
 */
	if ((shmid = shmget(SHM_SEG_SSC, 0, SHM_R | SHM_W)) < 0) {
		printf("error in shmget, shmid = 0x%x\n", shmid);
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}
	if ((shmptr = (uchar8 *)shmat(shmid, (void *)0x33000000, 0)) == (void *) -1) {
		printf("shmat error\n");
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}

	printf("SSC : PSM base at 0x%x\n", shmptr);

#ifdef SSC
	eee.shmem_base = (uint32)shmptr;
#endif

	if ((shmid = shmget(SHM_SEG_SSC_MGMT, 0, SHM_R | SHM_W)) < 0) {
		printf("error in shmget, shmid = 0x%x\n", shmid);
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}
	if ((shmptr = (uchar8 *)shmat(shmid, (void *)0x34000000, 0)) == (void *) -1) {
		printf("shmat error\n");
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}

	printf("SSC_MGMT : PSM base at 0x%x\n", shmptr);

#ifdef SSC_MGMT
	eee.shmem_base = (uint32)shmptr;
#endif

/*
 *
 * FCNIM CPUs
 *
 */

	if ((shmid = shmget(SHM_SEG_FC1, 0, SHM_R | SHM_W)) < 0) {
		printf("error in shmget, shmid = 0x%x\n", shmid);
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}
	if ((shmptr = (uchar8 *)shmat(shmid, (void *)0x35000000, 0)) == (void *) -1) {
		printf("shmat error\n");
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}

	printf("FC1 : PSM base at 0x%x\n", shmptr);

	if ((shmid = shmget(SHM_SEG_FC2, 0, SHM_R | SHM_W)) < 0) {
		printf("error in shmget, shmid = 0x%x\n", shmid);
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}
	if ((shmptr = (uchar8 *)shmat(shmid, (void *)0x36000000, 0)) == (void *) -1) {
		printf("shmat error\n");
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}

	printf("FC2 : PSM base at 0x%x\n", shmptr);

	if ((shmid = shmget(SHM_SEG_FC3, 0, SHM_R | SHM_W)) < 0) {
		printf("error in shmget, shmid = 0x%x\n", shmid);
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}
	if ((shmptr = (uchar8 *)shmat(shmid, (void *)0x37000000, 0)) == (void *) -1) {
		printf("shmat error\n");
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}

	printf("FC3 : PSM base at 0x%x\n", shmptr);

	if ((shmid = shmget(SHM_SEG_FC4, 0, SHM_R | SHM_W)) < 0) {
		printf("error in shmget, shmid = 0x%x\n", shmid);
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}
	if ((shmptr = (uchar8 *)shmat(shmid, (void *)0x38000000, 0)) == (void *) -1) {
		printf("shmat error\n");
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}

	printf("FC4 : PSM base at 0x%x\n", shmptr);

/*
 *
 * Well Known Addresses for init
 *
 */
#ifdef NFX_MOD_SSC
	if ((shmid = shmget(SHM_SEG_SSC_WKA, 0, SHM_R | SHM_W)) < 0) {
#endif
#ifdef NFX_MOD_NFP
	if ((shmid = shmget(SHM_SEG_NFP_WKA, 0, SHM_R | SHM_W)) < 0) {
#endif
		printf("error in shmget, shmid = 0x%x\n", shmid);
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}
	if ((shmptr = (uchar8 *)shmat(shmid, (void *)0x39000000, 0)) == (void *) -1) {
		printf("shmat error\n");
		return EEE_ERR_SM_POOL_UNAVAILABLE;
	}

	printf("WKA at 0x%x\n", shmptr);

	eee.wka = (uint32)shmptr;

#endif	/* LINUX_TEST */

#ifdef AGILE_HARDWARE

#if defined(FCNIM) && defined(BOBCAT)

	size = SHM_SEG_PSM_SIZE_FC;
	if (memorysize_MB == 256)
		eee.shmem_base = SW_RAM_BASE_CACHED + 0x26000000;
	else {
		eee.shmem_base = SW_RAM_BASE_CACHED + 0x25000000;
		size = SHM_SEG_PSM_SIZE_FC+0xf000000;
	}

#elif defined(FCNIM) && defined(CHEETAH)

	size = SHM_SEG_PSM_SIZE_FC;
#ifdef FC_USE_NEW_MEM_MAP
	if (memorysize_MB == 256)
		eee.shmem_base = SW_RAM_BASE_CACHED + 0x06000000;
	else {
		eee.shmem_base = SW_RAM_BASE_CACHED + 0x05000000;
		size = SHM_SEG_PSM_SIZE_FC+0xf000000;
	}
#else
	eee.shmem_base = 0x84000000;
#endif

#elif defined(PROM)

	size = SHM_SEG_PSM_SIZE_PROM;
	eee.shmem_base = PHYS_TO_K0(0x02000000);

#ifdef SIBYTE
	if (isTXRX())
		bzero((void *)0x73000000, SHM_SEG_SIZE_WKA);
#endif

#elif defined(SSC_MGMT)

	eee.shmem_base = 0x82000000;
	size = SHM_SEG_PSM_SIZE_SSC_MGMT;
	eee.wka = 0xA3FF0000;

#elif defined(NFP_TXRX) || defined(NFP_FP)
    eee.shmem_base = get_memory_virt_base(MMU_SM_MY_REGION);
    size = get_memory_region_size(MMU_SM_MY_REGION);
	eee.wka = (unsigned long)0x73000000;
	eee.wka = (unsigned long)0x73000000;
#else
	panic("unsupported\n");
#endif

	EEE_PRINTF(("SHARED MEMORY at %p, 0x%x bytes\n", (void *)eee.shmem_base, size));
/*
	memset(eee.shmem_base, 0, size);
*/

#endif	/* AGILE_HARDWARE */

	return NFX_OK;
}

/*-----------------------------------------------------------------
 * Name: eee_platGetSharedMemoryBase()
 *
 * Description:	Returns base address of Shared Memory on local CPU
 *-----------------------------------------------------------------
 */
address_t
eee_platGetSharedMemoryBase()
{
	return eee.shmem_base;
}

/*-----------------------------------------------------------------
 * Name:	eee_platGetSharedMemorySize()
 *
 * Description:	returns the amount of memory in the PCI shared pool
 *-----------------------------------------------------------------
 */
uint64
eee_platGetSharedMemorySize()
{
#if defined(NFP_TXRX) || defined(NFP_FP)
	return get_memory_region_size(MMU_SM_MY_REGION);
#elif defined(SSC)
	return SHM_SEG_PSM_SIZE_SSC;
#elif defined(SSC_MGMT)
	return SHM_SEG_PSM_SIZE_SSC_MGMT;
#elif defined(FCNIM)
#ifdef FC_USE_NEW_MEM_MAP
	if (memorysize_MB == 256)
		return SHM_SEG_PSM_SIZE_FC;
	else
		return (SHM_SEG_PSM_SIZE_FC+0xF000000);
#else
	return SHM_SEG_PSM_SIZE_FC;
#endif
#endif
}	/* eee_platGetSharedMemorySize() */

/*-----------------------------------------------------------------
 * Name:	eee_platGetMyPoolId()
 *
 * Description:	returns identifier to the appropriate memory pool id
 *	EEE_TXRX_POOL
 *	EEE_FP_POOL
 *	EEE_SSC_7000_POOL
 *	EEE_SSC_MGMT_POOL
 *	EEE_FC_POOL
 *	TEST_POOL_1
 *	TEST_POOL_2
 *-----------------------------------------------------------------
 */
uint32
eee_platGetMyPoolId()
{
	return EEE_TXRX_POOL;
}

/*-----------------------------------------------------------------
 * Name:
 * Description:
 *-----------------------------------------------------------------
 */
uint32
eee_platGetMyFwdId()
{
	return eee_index[1][nfxMyCPUId];

}

/*-----------------------------------------------------------------
 * Name:	eee_platGetNumSharedDesc()
 *
 * Description:	returns the number of descriptors available in the
 *		PCI shared memory pool.  These descriptors are the ones
 *		that will be distributed to the various Resource Queues
 *		in the other shared memory pools on the same module.
 *-----------------------------------------------------------------
 */
uint32
eee_platGetNumSharedDesc()
{
#if (EEE_NUM_SM_POOLS > 0)
	uint32	num_desc;

#ifdef EEE_NEW_RATIO
	num_desc = DESC_RATIO * eee.num_alloc_pages;
#else
	num_desc = ((eee.sm_for_desc_and_buf / eee.bytes_per_small_buf) * DESC_TO_SMALL_RATIO)/8;

#endif
	if (num_desc)
		num_desc -= 4;
	return (num_desc);
#else
	return 0;
#endif
}

/*-----------------------------------------------------------------
 * Name:	eee_platGetNumSharedBuffers()
 * Description:	returns the number of buffers of the requested size
 *		in the shared memory pool.
 *-----------------------------------------------------------------
 */
uint32
eee_platGetNumSharedBuffers(
	uint32	buf_size
)
{
#if (EEE_NUM_SM_POOLS > 0)
	uint32	num_bufs, ratio = 0;

#ifdef EEE_NEW_RATIO

	if (buf_size == EEE_BUF_SMALL)
		ratio = SMALL_RATIO;
	if (buf_size == EEE_BUF_LARGE)
		ratio = LARGE_RATIO;
	if (buf_size == EEE_BUF_ULTRA)
		ratio = ULTRA_RATIO;
#ifdef EEE_BUF_MGMT
	if (buf_size == EEE_BUF_MGMT)
#ifdef NFP_TXRX
		return (eee.mgmt_size_buf / eee.buf_size[EEE_BUF_MGMT]);
#else
		return 0;
#endif
#endif

	num_bufs = ratio * eee.num_alloc_pages;

#else
	if (buf_size == EEE_BUF_SMALL)
		ratio = 8;
	if (buf_size == EEE_BUF_LARGE)
		ratio = SMALL_TO_LARGE_RATIO;
	if (buf_size == EEE_BUF_ULTRA)
		ratio = SMALL_TO_ULTRA_RATIO;
#ifdef EEE_BUF_MGMT
	if (buf_size == EEE_BUF_MGMT)
#ifdef NFP_TXRX
		return (eee.mgmt_size_buf / eee.buf_size[EEE_BUF_MGMT]);
#else
		return 0;
#endif
#endif

	num_bufs = ((eee.sm_for_desc_and_buf / eee.bytes_per_small_buf) * ratio)/8;

#endif	/* EEE_NEW_RATIO */

	if (num_bufs)
		num_bufs -= 4;

	return (num_bufs);
#else
	return 0;
#endif

}

void
eee_platAdjustNumSharedBuffers()
{
#ifdef EEE_NEW_RATIO
	uint32	more_space;

	more_space = (eee_remainBytes() - eee.mgmt_stack_size  - 
                  EEE_STACK_POOL_RESERVE) % ALLOC_DIVISOR;

	if ((LARGE_RATIO > SMALL_RATIO) && (LARGE_RATIO > ULTRA_RATIO)) {
		eee.sm_num_buf[EEE_BUF_LARGE] += (more_space /eee.buf_size[EEE_BUF_LARGE]);
	}
	else if ((ULTRA_RATIO > SMALL_RATIO) && (ULTRA_RATIO > LARGE_RATIO)) {
		eee.sm_num_buf[EEE_BUF_ULTRA] += (more_space /eee.buf_size[EEE_BUF_ULTRA]);
	}
#endif
}

/*-----------------------------------------------------------------
 * Name:	eee_platGetNumSharedFwd()
 * Description:	returns the total number of entries in the fwd rcv queues
 *-----------------------------------------------------------------
 */
uint32
eee_platGetNumSharedFwd()
{
#if (EEE_NUM_FWD_QUEUES > 0)
	uint32	num_fwd;

#ifdef EEE_NEW_RATIO
	num_fwd = FWD_RATIO * eee.num_alloc_pages;
	num_fwd &= ~511;
#else
	num_fwd = eee.sm_num_desc;
	num_fwd = (num_fwd + 511) & ~511;
#endif

	return (num_fwd);
#else
	return 0;
#endif
}

/*-----------------------------------------------------------------
 * Name:	eee_platGetWKA
 *-----------------------------------------------------------------
 */
address_t
eee_platGetWKA()
{
	return (eee.wka);
}

/*-----------------------------------------------------------------
 * Name:	eee_initGetSharedMemAddrsFromOtherCPUs
 *
 * Description:	This is an important function.  It reads from a well-known
 *		address and retrieves the Resource Queue addresses in other
 *		CPUs shared memory, into which this CPU should write data,
 *		such as descriptors, buffers, ipc entries, and forwarding entries.
 *
 *		This function will block until it reads all the necessary
 *		data.  If it times out, an error code will be returned,
 *		and the card should panic.
 * Return Values: NFX_OK, ERR_INIT_FAILED_TO_GET_RQ_ADDR
 *-----------------------------------------------------------------
 */
int32
eee_initGetSharedMemAddrsFromOtherCPUs()
{
#if (EEE_NUM_SM_POOLS > 1)
	volatile eee_shmem_init_t	* shmem_ptr;
	int i, j;
	uint32						mem, ipc, fwd;
	uint32						index, mempool;
	uint32						timeout;

	EEE_PRINTF(("\n\n\n[eee_initGetSharedMemAddrsFromOtherCPUs]\n"));
	/*
	 * Wait until all CPUs on this card have copied their pointers to the
	 * WKA structures.
	 */
	shmem_ptr = (eee_shmem_init_t *)eee.wka;
	timeout = 0;
#ifdef LARGE_MEMORY
	watchdog_stop();
#endif
	for (i=0; i<EEE_NUM_SM_POOLS; i++, shmem_ptr++) {
		while (shmem_ptr->ready != EEE_SHMEM_ADDR_READY) {
			if (timeout++ > EEE_GET_ADDR_TIMEOUT) {
				shmem_ptr = (eee_shmem_init_t *)eee.wka;
				for (i=0; i<EEE_NUM_SM_POOLS; i++, shmem_ptr++) {
					if (shmem_ptr->ready != EEE_SHMEM_ADDR_READY)
						eee.shmem_avail[i] = 0;
					else
						eee.shmem_avail[i] = 1;
				}
				goto move_on;
/*
				return EEE_ERR_INIT_FAILED_TO_GET_RQ_ADDR;
*/
			}
		}
		eee.shmem_avail[i] = 1;
	}

move_on:

#ifdef LARGE_MEMORY
	watchdog_restart();
#endif
	/*
	 * Copy WKA structure pointers into EEE structures
	 */
	GET_MY_MEMPOOL_INDEX(mem);
	shmem_ptr = (eee_shmem_init_t *)eee.wka;
	for (i=EEE_NUM_LM_POOLS; i< EEE_NUM_MEM_POOLS; i++, shmem_ptr++) {
		eee.far_desc_pool[i].start = eee.far_desc_pool[i].head =
										shmem_ptr->rq_desc_pool[mem].start;
		eee.far_desc_pool[i].end = shmem_ptr->rq_desc_pool[mem].end;
		eee.desc_base[i] = shmem_ptr->desc_base;
		eee.desc_end[i] = shmem_ptr->desc_end;

		EEE_PRINTF(("far_desc_pool[%d].start = %p\n", i, shmem_ptr->rq_desc_pool[mem].start));
		EEE_PRINTF(("far_desc_pool[%d].end = %p\n", i, shmem_ptr->rq_desc_pool[mem].end));
		EEE_PRINTF(("desc_base[%d] = %p\n", i, shmem_ptr->desc_base));
		EEE_PRINTF(("desc_end[%d] = %p\n", i, shmem_ptr->desc_end));

		for (j=0; j<EEE_NUM_BUF_SIZES; j++) {
			eee.far_buf_pool[i][j].start = eee.far_buf_pool[i][j].head =
								shmem_ptr->rq_buf_pool[mem][j].start;
			eee.far_buf_pool[i][j].end =
								shmem_ptr->rq_buf_pool[mem][j].end;
			eee.buf_base[i][j] = shmem_ptr->buf_base[j];
			eee.buf_end[i][j] = shmem_ptr->buf_end[j];

			EEE_PRINTF(("far_buf_pool[%d][%d].start = %p\n", i, j, shmem_ptr->rq_buf_pool[mem][j].start));
			EEE_PRINTF(("far_buf_pool[%d][%d].end = %p\n", i, j, shmem_ptr->rq_buf_pool[mem][j].end));
			EEE_PRINTF(("buf_base[%d][%d] = %p\n", i, j, shmem_ptr->buf_base[j]));
			EEE_PRINTF(("buf_end[%d][%d] = %p\n", i, j, shmem_ptr->buf_end[j]));
		}
#ifdef EEE_ATTR
		eee.desc_attr[i] = shmem_ptr->desc_attr;
		for (j=0; j<EEE_NUM_BUF_SIZES; j++) {
			eee.buf_attr[i][j] = shmem_ptr->buf_attr[j];
		}
#endif
	}
	GET_MY_IPC_INDEX(ipc);
	GET_MY_FWD_INDEX(fwd);
	index = 0;

	shmem_ptr = (eee_shmem_init_t *)eee.wka;
	for (mempool=EEE_NUM_LM_POOLS; mempool<EEE_NUM_MEM_POOLS; mempool++, shmem_ptr++) {
	  EEE_PRINTF(("mempool = %d\n", mempool));

		if (eee.shmem_avail[mempool-EEE_NUM_LM_POOLS]) {
		  EEE_PRINTF(("shmem_avail[%d] = 1\n", mempool-EEE_NUM_LM_POOLS));
		  EEE_PRINTF(("index = %d, shmem_ptr = %p\n", index, shmem_ptr));
/*
			eee.ipc_send_start[index] = eee.ipc_send_curr[index] = shmem_ptr->ipc_rcv_start[ipc];
			eee.ipc_send_end[index] = shmem_ptr->ipc_rcv_end[ipc];
*/
			eee.fwd_queue[index].fwd_start = eee.fwd_queue[index].fwd_head =shmem_ptr->rcv_start[fwd];
			eee.fwd_queue[index].fwd_end = shmem_ptr->rcv_end[fwd];

			NFX_SPIN_INIT(&eee.fwd_queue[index].fwd_spin, SPINLOCK_LEVEL_UNKNOWN);
		}
		index++;
	}

#if defined(NFP_FP) || defined(NFP_TXRX)
	shmem_ptr = (eee_shmem_init_t *)eee.wka;
#ifdef NFP_TXRX
    shmem_ptr++;
#endif
    for (index = EEE_NUM_FWD_QUEUES;
         index < (EEE_NUM_FWD_QUEUES + EEE_NUM_FIXED_FWD_QUEUES);
         ++index) {
        eee.fwd_queue[index].fwd_start = eee.fwd_queue[index].fwd_head =
            shmem_ptr->rcv_start[index];
        eee.fwd_queue[index].fwd_end = shmem_ptr->rcv_end[index];
        NFX_SPIN_INIT(&eee.fwd_queue[index].fwd_spin,
                      SPINLOCK_LEVEL_UNKNOWN);

        EEE_PRINTF(("fixed queue %d fwd_start = %p end = %p\n",
                    index,
                    eee.fwd_queue[index].fwd_start,
                    eee.fwd_queue[index].fwd_end));
    }
#endif

#ifdef LARGE_MEMORY
	shmem_ptr = (eee_shmem_init_t *)eee.wka;
#ifdef NFP_TXRX
	shmem_ptr++;
#endif    
    for (i = 0; i < shmem_ptr->sm_num_regions; ++i) {
        volatile struct sm_region *r = &shmem_ptr->sm_regions[i];
        pte_setup_single(r->phys_offset,
                         r->virt,
                         r->size,
                         PTE_ENTRY_SIZE,
                         r->size);
        pte_setup_single(r->phys_offset,
                         (r->virt & ~MMU_REGION_MASK) | REMOTE_CACHED_MEM,
                         r->size,
                         PTE_ENTRY_SIZE,
                         r->size);
    }
#endif

#endif	/* EEE_NUM_SM_POOLS > 1 */
	return NFX_OK;

}

/*-----------------------------------------------------------------
 * Name:	eee_initPutSharedMemAddrsToOtherCPUs()
 *
 * Description: writes the local RQ addresses to the WKA in shared memory.
 *		The other CPUs on this card should read these addresses.
 *-----------------------------------------------------------------
 */
int32
eee_initPutSharedMemAddrsToOtherCPUs()
{
#if (EEE_NUM_SM_POOLS > 1)
	volatile eee_shmem_init_t	* shmem_ptr;
	int i, j;

	EEE_PRINTF(("\n\n\n[eee_initPutSharedMemAddrsToOtherCPUs]\n"));
	shmem_ptr = (eee_shmem_init_t *)eee.wka;

	for (i=0; i<eee.my_pool_id-SHARED_POOL_OFFSET-EEE_NUM_LM_POOLS; i++)
		shmem_ptr++;

	EEE_PRINTF(("shmem_ptr at %p\n", shmem_ptr));
	EEE_PRINTF(("eee.my_pool_id = %d\n", eee.my_pool_id));

	if ((EEE_NUM_MEM_POOLS > MAX_NUM_MEM_POOLS) ||
		(EEE_NUM_BUF_SIZES > MAX_NUM_BUF_SIZES) ||
		(EEE_NUM_IPC_QUEUES > MAX_NUM_IPC_QUEUES) ||
		(EEE_NUM_FWD_QUEUES > MAX_NUM_FWD_QUEUES)) {
		printf("Invalid number of resource queues\n");
		return EEE_ERR_TOO_MANY_RQ;
	}

	shmem_ptr->num_mem_pools = EEE_NUM_MEM_POOLS;
	shmem_ptr->num_ipc_queues = EEE_NUM_IPC_QUEUES;
	shmem_ptr->num_fwd_queues = EEE_NUM_FWD_QUEUES;
	shmem_ptr->num_buf_sizes = EEE_NUM_BUF_SIZES;

	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++) {

EEE_PRINTF(("rq_desc_pool[%d].start at %p = %p\n", i, &(shmem_ptr->rq_desc_pool[i].start), eee.desc_pool[i].queue.start));
EEE_PRINTF(("rq_desc_pool[%d].end at %p = %p\n", i, &(shmem_ptr->rq_desc_pool[i].end), eee.desc_pool[i].queue.end));
		shmem_ptr->rq_desc_pool[i].start = eee.desc_pool[i].queue.start;
		shmem_ptr->rq_desc_pool[i].end = eee.desc_pool[i].queue.end;
	}

	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++) {
		for (j=0; j<EEE_NUM_BUF_SIZES; j++) {
EEE_PRINTF(("rq_buf_pool[%d][%d].start at %p = %p\n", i, j, &(shmem_ptr->rq_buf_pool[i][j].start), eee.buf_pool[i][j].queue.start));
EEE_PRINTF(("rq_buf_pool[%d][%d].end at %p = %p\n", i, j, &(shmem_ptr->rq_buf_pool[i][j].end), eee.buf_pool[i][j].queue.end));
			shmem_ptr->rq_buf_pool[i][j].start = eee.buf_pool[i][j].queue.start;
			shmem_ptr->rq_buf_pool[i][j].end = eee.buf_pool[i][j].queue.end;
		}
	}

#if EEE_NUM_IPC_QUEUES > 0
	for (j=0; j<EEE_NUM_IPC_QUEUES; j++) {
			shmem_ptr->ipc_rcv_start[j] = eee.ipc_rcv_start[j];
			shmem_ptr->ipc_rcv_end[j] = eee.ipc_rcv_end[j];
	}
#endif    

	for (j=0; j<EEE_NUM_FWD_QUEUES + EEE_NUM_FIXED_FWD_QUEUES; j++) {
	  EEE_PRINTF(("rcv_start[%d] at %p = %p\n", j, &(shmem_ptr->rcv_start[j]), eee.rcv_queue[j].rcv_start));
	  EEE_PRINTF(("rcv_end[%d] at %p = %p\n", j, &(shmem_ptr->rcv_end[j]), eee.rcv_queue[j].rcv_end));
			shmem_ptr->rcv_start[j] = eee.rcv_queue[j].rcv_start;
			shmem_ptr->rcv_end[j] = eee.rcv_queue[j].rcv_end;
	}

	/*
	 * write tail pointer addresses
	 */
	for (i=EEE_NUM_LM_POOLS; i<EEE_NUM_MEM_POOLS; i++) {
	  EEE_PRINTF(("desc_tail_ptr[%d] at %p = %p\n",
		      i, &(shmem_ptr->desc_tail_ptr[i]), eee.far_desc_pool[i].tail_ptr));

		shmem_ptr->desc_tail_ptr[i] = (address_t)eee.far_desc_pool[i].tail_ptr;

		for (j=0; j<EEE_NUM_BUF_SIZES; j++) {

		  EEE_PRINTF(("buf_tail_ptr[%d][%d] at %p = %p\n",
	    i, j, &(shmem_ptr->buf_tail_ptr[i][j]), eee.far_buf_pool[i][j].tail_ptr));
			shmem_ptr->buf_tail_ptr[i][j] = (address_t)eee.far_buf_pool[i][j].tail_ptr;
		}
	}

	for (j=0; j<EEE_NUM_FWD_QUEUES; j++) {
EEE_PRINTF(("fwd_tail_ptr[%d] at %p = %p\n", j, &(shmem_ptr->fwd_tail_ptr[j]), eee.fwd_queue[j].fwd_tail_ptr));
			shmem_ptr->fwd_tail_ptr[j] = (address_t)eee.fwd_queue[j].fwd_tail_ptr;
	}

    shmem_ptr->fwd_tail_ptr[EEE_FS_RPC_QUEUE_INDEX] = (address_t)eee.fwd_queue[EEE_FS_RPC_QUEUE_INDEX].fwd_tail_ptr;

	/*
	 * Write buffer and descriptor address ranges
	 */
EEE_PRINTF(("desc_base at %p = %p\n", &(shmem_ptr->desc_base), eee.desc_base[eee.my_pool_id - SHARED_POOL_OFFSET]));
EEE_PRINTF(("desc_end at %p = %p\n", &(shmem_ptr->desc_end), eee.desc_end[eee.my_pool_id - SHARED_POOL_OFFSET]));
	shmem_ptr->desc_base = eee.desc_base[eee.my_pool_id - SHARED_POOL_OFFSET];
	shmem_ptr->desc_end = eee.desc_end[eee.my_pool_id - SHARED_POOL_OFFSET];
	for (j=0; j<EEE_NUM_BUF_SIZES; j++) {
EEE_PRINTF(("buf_base[%d] at %p = %p\n", j, &(shmem_ptr->buf_base[j]), eee.buf_base[eee.my_pool_id - SHARED_POOL_OFFSET][j]));
EEE_PRINTF(("buf_end[%d] at %p = %p\n", j, &(shmem_ptr->buf_end[j]), eee.buf_end[eee.my_pool_id - SHARED_POOL_OFFSET][j]));
		shmem_ptr->buf_base[j] =
						eee.buf_base[eee.my_pool_id - SHARED_POOL_OFFSET][j];
		shmem_ptr->buf_end[j] =
						eee.buf_end[eee.my_pool_id - SHARED_POOL_OFFSET][j];
	}

#ifdef LARGE_MEMORY
    for (i = 0; i < array_len(mmu_mapped_regions); ++i) {
        struct mmu_mapped_region *r = &mmu_mapped_regions[i];
        if ((r->virt_start & MMU_REGION_MASK) == 
            LOCAL_MEM) {
            int num_regions = shmem_ptr->sm_num_regions;
            if (num_regions == sizeof(shmem_ptr->sm_regions) /
                sizeof(shmem_ptr->sm_regions[0])) {
                panic("%s: too many regions\n");
            }
            
            volatile struct sm_region *sr =
                &shmem_ptr->sm_regions[num_regions];
            sr->phys_offset = r->phys_offset_start;
            sr->size = mmu_region_size[i];
            sr->virt = r->virt_start;

            shmem_ptr->sm_num_regions = num_regions + 1;
        }
    }
#endif

#ifdef EEE_ATTR
	shmem_ptr->desc_attr = eee.desc_attr[eee.my_pool_id - SHARED_POOL_OFFSET];
	for (j=0; j<EEE_NUM_BUF_SIZES; j++) {
		shmem_ptr->buf_attr[j] = eee.buf_attr[eee.my_pool_id - SHARED_POOL_OFFSET][j];
	}
#endif
	shmem_ptr->ready = EEE_SHMEM_ADDR_READY;
#endif	/* EEE_NUM_SM_POOLS > 1 */
	return NFX_OK;
}

/*-----------------------------------------------------------------
 * Name:
 * Description:
 *-----------------------------------------------------------------
 */
void
eee_initGetTailPointers()
{
#if (EEE_NUM_SM_POOLS > 1)
	volatile eee_shmem_init_t	* shmem_ptr;
	uint32						i, j;
	uint32						mem, ipc, fwd;
	uint32						index, mempool;

	EEE_PRINTF(("[eee_initGetTailPointers]\n"));
	shmem_ptr = (eee_shmem_init_t *)eee.wka;

	GET_MY_MEMPOOL_INDEX(mem);

	for (i=EEE_NUM_LM_POOLS; i< EEE_NUM_MEM_POOLS; i++, shmem_ptr++) {
        if (mem == i) {
            continue;
        }
		eee.desc_pool[i].queue.tail_ptr = (address_t **)
												shmem_ptr->desc_tail_ptr[mem];
EEE_PRINTF(("initGetTailPointers, desc_pool[%d] = %p\n", i, (void *)shmem_ptr->desc_tail_ptr[mem]));
		for (j=0; j<EEE_NUM_BUF_SIZES; j++) {
EEE_PRINTF(("initGetTailPointers, buf_pool[%d][%d] = %p\n", i, j, (void *)shmem_ptr->buf_tail_ptr[mem][j]));
			eee.buf_pool[i][j].queue.tail_ptr =
				 				(address_t **)shmem_ptr->buf_tail_ptr[mem][j];
		}
        eee.rcv_queue[EEE_FS_RPC_QUEUE_INDEX].rcv_tail_ptr = (eee_descPtr_t **)
                                            shmem_ptr->fwd_tail_ptr[EEE_FS_RPC_QUEUE_INDEX];
	}

	GET_MY_IPC_INDEX(ipc);
	GET_MY_FWD_INDEX(fwd);
	index = 0;
	shmem_ptr = (eee_shmem_init_t *)eee.wka;
	for (mempool=EEE_NUM_LM_POOLS; mempool<EEE_NUM_MEM_POOLS; mempool++, shmem_ptr++) {
		if (eee.shmem_avail[mempool-EEE_NUM_LM_POOLS]) {
EEE_PRINTF(("initGetTailPointers, rcv_tail_ptr[%d] = %p\n", index, (void *)shmem_ptr->fwd_tail_ptr[ipc]));
			eee.rcv_queue[index].rcv_tail_ptr = (eee_descPtr_t **)
												shmem_ptr->fwd_tail_ptr[fwd];
			index++;
		}
		else {
			index++;
		}
	}

#endif	/* EEE_NUM_SM_POOLS > 1 */

}	/* eee_initGetTailPointers() */

