/*
 *-----------------------------------------------------------------
 *
 * Name:
 *
 * RCS:  $Id: eee-platform.h,v 1.20 2002/11/07 01:20:03 rick Exp $
 *
 * Copyright (C) 2001, Agile Storage, Inc.
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */

#ifndef _EEE_PLATFORM_H
#define _EEE_PLATFORM_H

#if defined(AGILE_HARDWARE)

#define SHM_SEG_PSM_SIZE_TXRX		0x4000000	/* see note above */
#define SHM_SEG_PSM_SIZE_FP			0x7000000	/* see note above */
#define SHM_SEG_PSM_SIZE_FC			0xA000000
#ifdef SIBYTE
#define SHM_SEG_PSM_SIZE_PROM		0x1000000
#else
#ifdef DIAG_R7000
#define SHM_SEG_PSM_SIZE_PROM		0x1000000
#else
#define SHM_SEG_PSM_SIZE_PROM		0x400000
#endif
#endif
#define SHM_SEG_PSM_SIZE_SSC_MGMT	0x1000000
#define SHM_SEG_SIZE_WKA			0x10000

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern int32
eee_shmemGetSharedMemoryPools();

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern address_t
eee_platGetSharedMemoryBase();

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern uint64
eee_platGetSharedMemorySize();

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern uint32
eee_platGetMyPoolId();

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern uint32
eee_platGetMyFwdId();

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern uint32
eee_platGetNumSharedDesc();

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern uint32
eee_platGetNumSharedBuffers(
    uint32  buf_size
);

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern void
eee_platAdjustNumSharedBuffers();

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern uint32
eee_platGetNumSharedFwd();

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern address_t
eee_platGetWKA();

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern int32                            /* NFX_OK or
                                         * EEE_ERR_INIT_FAILED_TO_GET_RQ_ADDR
                                         */
eee_initGetSharedMemAddrsFromOtherCPUs();

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern int32
eee_initPutSharedMemAddrsToOtherCPUs();

/*-----------------------------------------------------------------
 * Name:
 *
 * Description:
 *
 * Created by:	Rick Lund
 *
 * Date Created:
 *
 *-----------------------------------------------------------------
 */
extern void
eee_initGetTailPointers();

#elif defined(LINUX_TEST)

/*
 * Shared Memory definitions
 */
#define SHM_SEG_TXRX		11
#define SHM_SEG_FP			12
#define SHM_SEG_SSC			13
#define SHM_SEG_SSC_MGMT	14
#define SHM_SEG_FC1			15
#define SHM_SEG_FC2			16
#define SHM_SEG_FC3			17
#define SHM_SEG_FC4			18

/*
 * Well Known Address for passing init information
 */
#define SHM_SEG_SSC_WKA			80
#define SHM_SEG_NFP_WKA			81
#define SHM_SEG_FCNIM_WKA		82

#define SHM_SEG_PSM_SIZE_TXRX		0x1000000
#define SHM_SEG_PSM_SIZE_FP			0x1000000
#define SHM_SEG_PSM_SIZE_SSC		0x1000000
#define SHM_SEG_PSM_SIZE_SSC_MGMT	0x1000000
#define SHM_SEG_PSM_SIZE_FC			0x800000
#define SHM_SEG_PSM_SIZE_PROM		0x400000
#define SHM_SEG_SIZE_WKA			0x10000

/*
 * Shared Memory areas for intercard messaging - MP switch
 */
#define SHM_SEG_MP_SSC			100
#define SHM_SEG_MP_TXRX1		101
#define SHM_SEG_MP_TXRX2		102
#define SHM_SEG_MP_FP1			103
#define SHM_SEG_MP_FP2			104
#define SHM_SEG_MP_FC1			105
#define SHM_SEG_MP_FC2			106
#define SHM_SEG_MP_FC3			107
#define SHM_SEG_MP_FC4			108

#define SHM_SEG_MP_SIZE			0x100000

/*
 * Shared Memory areas for intercard messaging - DP switch
 */
#define SHM_SEG_DP_TXRX			110
#define SHM_SEG_DP_FP			111
#define SHM_SEG_DP_FC1			112
#define SHM_SEG_DP_FC2			113
#define SHM_SEG_DP_FC3			114
#define SHM_SEG_DP_FC4			115

#define SHM_SEG_DP_SIZE			0x100000

/*
 * Semaphores for messaging queues:
 *		Mgmt Plane Switch, Data Plane Switch, and NFP's SMP forwarding queues
 */
#define SEM_MP_SSC				50
#define SEM_MP_TXRX1			51
#define SEM_MP_TXRX2			52
#define SEM_MP_FP1				53
#define SEM_MP_FP2				54
#define SEM_MP_FC1				55
#define SEM_MP_FC2				56
#define SEM_MP_FC3				57
#define SEM_MP_FC4				58

#define SEM_DP_TXRX				60
#define SEM_DP_FP				61
#define SEM_DP_FC1				62
#define SEM_DP_FC2				63
#define SEM_DP_FC3				64
#define SEM_DP_FC4				65

#define SEM_FWD_TO_TXRX			70
#define SEM_FWD_TO_FP			71

typedef struct shm_tx {
	uint32	tx_offset;
	uint32	rx_offset;
	uint32	start_offset;
	uint32	end_offset;
	uint32	tx_bytes_avail;
	uint32	res[3];
} shm_tx_t;

extern int32	linux_mp_sem[NFX_NUM_SLOTS_PER_CHASSIS][NFX_MAX_CPUS_PER_SLOT];
extern int32	linux_dp_sem[NFX_NUM_SLOTS_PER_CHASSIS][NFX_MAX_CPUS_PER_SLOT];
extern int32	linux_fwd_sem[NFX_NUM_SLOTS_PER_CHASSIS][NFX_MAX_CPUS_PER_SLOT];
extern shm_tx_t	* linux_mp[NFX_NUM_SLOTS_PER_CHASSIS][NFX_MAX_CPUS_PER_SLOT];
extern shm_tx_t	* linux_dp[NFX_NUM_SLOTS_PER_CHASSIS][NFX_MAX_CPUS_PER_SLOT];

#endif

#endif	/* _EEE_PLATFORM_H */

