/*
 * ACPU thread
 */
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/delay.h>

#define ACPU_CORE_NUM 3

//extern int acpu_init(void *);
int
acpu_init(void *arg)
{
	int my_cpu = smp_processor_id();
	int j;

	lock_kernel();
	daemonize("acpu_");
	unlock_kernel();

	printk(KERN_INFO "The ACPU says: hello world from core %d!\n", my_cpu);
	while (1) {
		for (j = 0; j < 0x800000; j++) {
			if (j == my_cpu) {
				msleep(10);
			}
		}
	}
	return 0;
}

static int __init
acpu_threadg_init(void)
{
	cpumask_t mask;
	int err;

	/*
	 * set cpu mask to run thread group only on 4th CPU core
	 */
	mask = current->cpus_allowed;
	set_cpus_allowed(current, cpumask_of_cpu(ACPU_CORE_NUM));
	err = kernel_thread(acpu_init, NULL, 0);
	set_cpus_allowed(current, mask);

	return err;
}

static void __exit
acpu_mod_exit(void)
{
}

MODULE_LICENSE("GPL");
module_init(acpu_threadg_init);
module_exit(acpu_mod_exit);
