/*-----------------------------------------------------------------
 * Name:    nfx-error.h
 *
 * Description: module error ranges
 *
 * Created by:  Rick Lund
 *
 * Date Created:    4/9/01
 *
 * Copyright (C) 2001, 2006 Agile Storage Inc.
 *-----------------------------------------------------------------
 */

#ifndef _NFX_ERROR_H
#define _NFX_ERROR_H

#define NFX_ERROR_BASE      0xFFFFFF00

#define EEE_ERROR_BASE      (NFX_ERROR_BASE-0)
#define HASH_ERROR_BASE     (NFX_ERROR_BASE-0x100)
#define QUEUE_ERROR_BASE    (NFX_ERROR_BASE-0x200)
#define TIMER_ERROR_BASE    (NFX_ERROR_BASE-0x300)
#define SBM_ERROR_BASE      (NFX_ERROR_BASE-0x400)
#define ESM_ERROR_BASE      (NFX_ERROR_BASE-0x500)
#define SCSI_ERROR_BASE     (NFX_ERROR_BASE-0x600)
#define DP83820_ERROR_BASE  (NFX_ERROR_BASE-0x700)
#define FC_ERROR_BASE       (NFX_ERROR_BASE-0x800)
#define ISCSI_ERROR_BASE    (NFX_ERROR_BASE-0x900)
#define MALLOC_ERROR_BASE   (NFX_ERROR_BASE-0xA00)
#define SERIO_ERROR_BASE    (NFX_ERROR_BASE-0xB00)
#define PCI_ERROR_BASE      (NFX_ERROR_BASE-0xC00)
#define LUC_ERROR_BASE      (NFX_ERROR_BASE-0xD00)
#define PKT_ERROR_BASE      (NFX_ERROR_BASE-0xE00)
#define TPL_ERROR_BASE      (NFX_ERROR_BASE-0xF00)
#define BSD_ERROR_BASE      (NFX_ERROR_BASE-0x1000)
#define FS_ERROR_BASE       (NFX_ERROR_BASE-0x1100)
#define MNT_ERROR_BASE      (NFX_ERROR_BASE-0x1300)
#define FROM_UPGRADE_ERROR_BASE (NFX_ERROR_BASE-0x1400)
#define EVM_ERROR_BASE      (NFX_ERROR_BASE-0x1500)
#define RMC_ERROR_BASE      (NFX_ERROR_BASE-0x1600)
#define CLUSTER_ERROR_BASE  (NFX_ERROR_BASE-0x1700)
#define SANM_AG_ERROR_BASE  (NFX_ERROR_BASE-0x1800)
#define SANM_D_ERROR_BASE   (NFX_ERROR_BASE-0x1900)


/* Use this to make run-time assertions. */
#ifdef DEBUG
#ifdef SSC
#define NFX_ASSERT(_expr)                                     \
    if (!(_expr))                                             \
    {                                                         \
        extern int  printf  (const char *, ...);              \
        printf("%s:%d: ASSERT FAILED: %s in %s\n",            \
            __FILE__, __LINE__, #_expr, __FUNCTION__);        \
        exit(NFX_ERR);                                        \
    }
#else
#define NFX_ASSERT(_expr)                                     \
    ((void) ((_expr) ? 0 :                                    \
       (panic("%s:%d: ASSERT FAILED: %s in %s\n",             \
               __FILE__, __LINE__, #_expr, __FUNCTION__))))
#endif
#else
#define NFX_ASSERT(_expr)  ((void) 0)
#endif

/* Use this to make compile-time assertions. */
#ifdef __GNUC__
#define NFX_ASSERT_STATIC(_expr) \
    extern char nfx_compileTimeAssertion[(_expr) ? 1 : -1]  \
             __attribute__ ((unused))
#else
#define NFX_ASSERT_STATIC(_expr) \
    extern char nfx_compileTimeAssertion[(_expr) ? 1 : -1]
#endif

#endif  /* _NFX_ERROR_H */

