/* vi:ts=4
 *-----------------------------------------------------------------
 *
 * Name:        pkt-api.h
 *
 * RCS:  $Id: pkt-api.h,v 1.10 2002/10/22 01:30:40 jong Exp $
 *
 * Copyright (C) 2001, Agile Storage, Inc.
 *
 * Description: PKT related data structure definitions & function 
 *                              prototypes.
 *
 * Created by:  Shaun Hui
 *
 * Date Created: 6/01/01
 *
 *-----------------------------------------------------------------
 */

#ifndef _PKT_API_H
#define _PKT_API_H

// #include "../sm-pkt/pkt.h"
// #include "../sm-eee/eee-api.h"

#define RPC_LAST_FRAG           0x80000000
#define RPC_DELIMIT_FRAG        0x00000000

struct _tpl_connCb;
struct socket;

void pkt_freePkt( struct sk_buff *pDesc);
void pkt_freeDesc(struct sk_buff *pDesc);

struct sk_buff *pkt_allocPkt(void);
struct sk_buff *pkt_allocDesc(void);

#ifdef UNIT_TEST
struct sk_buff *pkt_allocPkt_test(void);
#endif

void pkt_showStats( void );
void pkt_showDesc( struct sk_buff *pDesc );

void pkt_validateDesc(struct sk_buff *pDesc);
int32 pkt_AdjPkt(struct sk_buff *pdesc, int offset );
struct sk_buff * pkt_dupPkt(struct sk_buff *pdesc);
struct sk_buff * pkt_dupPktChain(struct sk_buff *pdesc);

#define PKT_FREE_DESC(pkt)      pkt_freeDesc(pkt)

#define PKT_DUP_PACKET(pkt) pkt_dupPkt(pkt)

void pkt_finishInitialization(struct socket *so, struct sk_buff *pDesc);

/*++

Routine Description:
    Add RPC marker for the TCP RPC packet.

Arguments:
    pDesc - packet descriptor
    rpc_size - the RPC size

Return Value:
    None.

--*/
static inline void
pkt_add_rpc_marker(struct sk_buff *pDesc, uint32 rpc_size)
{
#ifdef LATER
    /* Adjust pHdr to include RPC marker.
     */
    pDesc->pHdr -= 4 ;
    pDesc->hdrSize += 4 ;

    /* Write the RPC Maker. We do not use fragmented RPC, the first fragment
     * is always the last.
     */
    *(uint32 *)pDesc->pHdr = htonl(RPC_LAST_FRAG | rpc_size);
#endif
}


/*++

Routine Description:

    Free the packet sent by an application from NCPU.

Arguments:

    pkt - packet descriptor

Return Value:

    None.

--*/

void
pkt_acpu_free_from_ncpu(struct sk_buff *pkt);


/*-----------------------------------------------------------------
 * Name         : pkt_pdescToMbuf
 *
 * Description  : Converts a packet in a Packet Descriptor chain to a
 *                mbuf with an extended buffer. 
 *                Also sets a flag in the mbuf to denote that
 *                checksum computation (IP, TCP/UDP) is complete.
 *
 * Arguments    : pdesc     - Original Packet descriptor chain
 *                mp        - Pointer-Pointer of the resulting
 *                            mbuf. This is set to NULL if the operation
 *                            fails or if there are no packet descriptors
 *                            to copy.
 *                keepPkt   - Keep a reference to the pkt descriptor
 *                            for future use. 
 *                            Note: This implies the pdesc is fully
 *                                  constructed and sent out as is.
 *
 * Returns      : NFX_OK    : Conversion successful.
 *                NFX_ERR   : Conversion failed.
 *                
 * Created by   : Kiran Srinivasan
 *
 * Date Created : 02/10/04
 *-----------------------------------------------------------------
 */

int32 pkt_pdescToMbuf(struct sk_buff  *pdesc, void **mp, boolean keepPkt);

/*-----------------------------------------------------------------
 * Name         : pkt_mbufToPdesc
 *
 * Description  : Converts a mbuf to a packet in a Packet Descriptor 
 *                chain. 
 *
 * Arguments    : mp       - Original mbuf
 *                pkt      - Pointer-Pointer of the resulting pkt. 
 *                           This is set to NULL if the operation fails 
 *
 * Returns      : NFX_OK    : Conversion successful.
 *                NFX_ERR   : Conversion failed.
 *                
 * Created by   : Nitin Parab
 *
 * Date Created : 03/10/04
 *-----------------------------------------------------------------
 */

int32 pkt_mbufToPdesc(void *m, short type, struct sk_buff **ret_pdesc);

/*-----------------------------------------------------------------
 *
 * Description  : Converts an outgoing packet to appear like an incoming
 *                packet.
 *                
 * Arguments    : pdesc     - Original Packet 
 *
 * Returns      : None.
 *                
 * Created by   : Kiran Srinivasan
 *
 * Date Created : 09/30/04
 *-----------------------------------------------------------------
 */
void pkt_outToIn(struct sk_buff *pdesc);

#ifdef LATER
struct ifnet;
#endif

/*++

Routine Description:

    Convert a packet chain into mbuf chain.

Arguments:

    pkt - beginning of the chain
    data - pointer to the beginning of the data in the packet
    len - the length of data to copy, should match the remainder
          of the chain
    ifp - assign this interface to allocated mbufs.

Return Values:

    Returns the allocated mbuf chain or NULL if not enough memory.

--*/
struct mbuf *
pkt_chainToMbuf(struct sk_buff *pkt, char *data, int len, void *ifp); /* struct ifnet *ifp */

#endif
