/*
 * Support for the Dallas Semcondutor 1511 RTC.
 * Copyright (C) Onstor, Inc. 2005.
 */
#ifndef __ds1511_h
#define __ds1511_h

typedef enum ds1511reg {
	DS1511_SEC = 0x0,
	DS1511_MIN = 0x1,
	DS1511_HOUR = 0x2,
	DS1511_DOW = 0x3,
	DS1511_DOM = 0x4,
	DS1511_MONTH = 0x5,
	DS1511_YEAR = 0x6,
	DS1511_CENTURY = 0x7,
	DS1511_AM1_SEC = 0x8,
	DS1511_AM2_MIN = 0x9,
	DS1511_AM3_HOUR = 0xa,
	DS1511_AM4_DATE = 0xb,
	DS1511_WD_MSEC = 0xc,
	DS1511_WD_SEC = 0xd,
	DS1511_CONTROL_A = 0xe,
	DS1511_CONTROL_B = 0xf,
	DS1511_RAMADDR_LSB = 0x10,
	DS1511_RAMDATA = 0x13
} ds1511reg_t;

#define DS1511_CONTROL_A_BLF1 	0x80
#define DS1511_CONTROL_A_BLF2 	0x40
#define DS1511_CONTROL_A_PRS 	0x20
#define DS1511_CONTROL_A_PAB 	0x10
#define DS1511_CONTROL_A_TDF 	0x08
#define DS1511_CONTROL_A_KSF 	0x04
#define DS1511_CONTROL_A_WDF 	0x02
#define DS1511_CONTROL_A_IRQF 	0x01
#define DS1511_CONTROL_B_TE 	0x80
#define DS1511_CONTROL_B_CS 	0x40
#define DS1511_CONTROL_B_BME 	0x20
#define DS1511_CONTROL_B_TPE 	0x10
#define DS1511_CONTROL_B_TIE 	0x08
#define DS1511_CONTROL_B_KIE 	0x04
#define DS1511_CONTROL_B_WDE 	0x02
#define DS1511_CONTROL_B_WDS 	0x01

#define RTC_CMD		DS1511_CONTROL_B
#define RTC_CMD1	DS1511_CONTROL_A
#define RTC_TDF 	DS1511_CONTROL_A_TDF
#define RTC_WDE 	DS1511_CONTROL_B_WDE
#define RTC_IRQF	DS1511_CONTROL_A_IRQF
#define RTC_WDF		DS1511_CONTROL_A_WDF

#define RTC_ALARM_SEC	DS1511_AM1_SEC
#define RTC_ALARM_MIN	DS1511_AM2_MIN
#define RTC_ALARM_HOUR	DS1511_AM3_HOUR
#define RTC_ALARM_DATE	DS1511_AM4_DATE

#define RTC_SEC		DS1511_SEC
#define RTC_MIN 	DS1511_MIN
#define RTC_HOUR 	DS1511_HOUR
#define RTC_DOW 	DS1511_DOW
#define RTC_DOM 	DS1511_DOM
#define RTC_MON 	DS1511_MONTH
#define RTC_YEAR 	DS1511_YEAR
#define RTC_CENTURY 	DS1511_CENTURY

#define RTC_TIE	DS1511_CONTROL_B_TIE
#define RTC_TE 	DS1511_CONTROL_B_TE
#define RTC_DATE_SET RTC_TE
#define RTC_COLDRESET_ENABLE	DS1511_CONTROL_B_WDE|DS1511_CONTROL_B_WDS
#define RTC_RESET_ENABLE	DS1511_CONTROL_B_WDE

#define RTC_WD_MSEC	DS1511_WD_MSEC
#define RTC_WD_SEC	DS1511_WD_SEC

void ds1511_init_watchdog(int sec, int msec);
void ds1511_disable_watchdog(void);
void ds1511_enable_watchdog(int onceflag, int resetflag);
void ds1511_do_reset(void);
void ds1511_do_coldreset(void);

#define DS1511_BASE 	0xbf000000

static inline void
rtc_write(uint8_t val, uint32_t reg)
{
	*((uint8_t *)((unsigned)DS1511_BASE + reg * 8)) = val;
}

static inline void
rtc_write_alarm(uint8_t val, ds1511reg_t reg)
{
	rtc_write((val | 0x80), reg);
}

static inline uint8_t
rtc_read(ds1511reg_t reg)
{
	return (*((uint8_t *)((unsigned)DS1511_BASE + reg * 8)));
}

static inline void
rtc_disable_date(void)
{
	rtc_write((rtc_read(RTC_CMD) & ~RTC_DATE_SET), RTC_CMD);
}

static inline void
rtc_enable_date(void)
{
	rtc_write((rtc_read(RTC_CMD) | RTC_DATE_SET), RTC_CMD);
}

#endif
