/*
 * Copyright (c) 2004 ONStor, Inc.
 * All rights reserved.
 *
 * This file implements routines to initialize the boards ethernet
 * mac addresses based on the values stored in the serial eeprom.
 */
#include <linux/types.h>

char eee_ssc_ext_mac[2][6];
void init_ether_addrs(uint32_t ipaddr, uint8_t *mac0, uint8_t *mac1);

#define SEEP_LOCATION 0xbc040000

#define SEEP_SIG_LEN				(4+1)
#define	SEEP_PCB_MODEL_LEN			(9+1)
#define	SEEP_PCB_ASSEMBLY_LEN		(13+1)
#define	SEEP_PCB_SERIAL_LEN			(10+1)
#define	SEEP_PCB_REVISION_LEN		(4+1)
#define	SEEP_PCB_DEVIATION_LEN		(11+1)
#define	SEEP_PCB_IP_ADDR_LEN		(15+1)
#define	SEEP_PCB_IP_MASK_LEN		(15+1)
#define	SEEP_PCB_DIAG_TEST_LEN		(1+1)
#define	SEEP_PCB_RESULT_LEN		(1+1)
#define	SEEP_PCB_DATE_LEN		(6+1)
#define	SEEP_PCB_MISC_INFO_LEN		(8+1)
#define	SEEP_PCB_UPTIME_LEN		(3+1)
#define	SEEP_PCB_REBOOTNUM_LEN		(1+1)

#define SEEP_CHASSIS_MODEL_LEN		(15+1)
#define	SEEP_CHASSIS_SERIAL_LEN		(10+1)
#define	SEEP_CHASSIS_REVISION_LEN	(5+1)
#define	SEEP_CHASSIS_DEVIATION_LEN	(5+1)
#define SEEP_CHASSIS_MAC_ADDR_LEN	(12+1)
#define	SEEP_CHASSIS_UPTIME_LEN		(4+1)
#define	SEEP_CHASSIS_REBOOTNUM_LEN	(1+1)

#define SEEP_ENV_START		147
#define SEEP_NVRAM_START	179
#define SEEP_VER_STRING_LEN_SIZE  (SEEP_TOTAL_LEN-SEEP_NVRAM_START-1 )

typedef struct {
    unsigned char  signature[SEEP_SIG_LEN]; // 5
    unsigned char  model_num[SEEP_CHASSIS_MODEL_LEN]; //16
    unsigned char  assembly_num[SEEP_PCB_ASSEMBLY_LEN]; //14
    unsigned char  serial_num[SEEP_PCB_SERIAL_LEN]; // 11
    unsigned char  revision[SEEP_PCB_REVISION_LEN]; // 5
    unsigned char  deviation[SEEP_PCB_DEVIATION_LEN]; // 12
    unsigned char  result_ict[SEEP_PCB_RESULT_LEN]; // 2
    unsigned char  date_ict[SEEP_PCB_DATE_LEN]; // 7
    unsigned char  result_qt[SEEP_PCB_RESULT_LEN]; // 2
    unsigned char  result_ft[SEEP_PCB_RESULT_LEN]; // 2
    unsigned char  result_dvt[SEEP_PCB_RESULT_LEN]; // 2
    unsigned char  result_ess[SEEP_PCB_RESULT_LEN]; // 2
    unsigned char  date_ess[SEEP_PCB_DATE_LEN]; // 7
    unsigned char  ip_addr[SEEP_PCB_IP_ADDR_LEN]; // 16
    unsigned char  ip_mask[SEEP_PCB_IP_MASK_LEN]; // 16
    unsigned char  no_of_reboots[SEEP_PCB_REBOOTNUM_LEN]; // 2
    unsigned char  mac_addr[SEEP_CHASSIS_MAC_ADDR_LEN]; //13
    unsigned char  uptime_since_reboot[SEEP_PCB_UPTIME_LEN]; // 4
    unsigned char  cumulative_uptime[SEEP_PCB_UPTIME_LEN]; // 4
    unsigned char  cluster_uptime[SEEP_CHASSIS_UPTIME_LEN]; // 5
} seepPCB_t;

#define isdigit(c)	  (((c) >= '0') && ((c) <= '9'))
#define isalpha(c)	( (((c) >= 'A') && ((c) <= 'Z')) || \
			  (((c) >= 'a') && ((c) <= 'z')) )
#define	isupper(c)	((c) >= 'A' && (c) <= 'Z')

#ifdef CONFIG_ONSTOR_BOBCAT
static int
char_to_int(char c)
{
	if (isdigit(c))
		return c - '0';
	else if (isalpha(c))
		return isupper(c) ? (c - 'A') + 10 : (c - 'a') + 10;
	else
		return -1;
}
#endif

static void
init_etheraddr(uint8_t *mac_addr, uint8_t *etheraddr, uint32_t port)
{
	etheraddr[0] = 0x00;
	etheraddr[1] = 0x07;
	etheraddr[2] = 0x34;
#ifdef CONFIG_ONSTOR_BOBCAT
	etheraddr[3] = ((char_to_int(mac_addr[6]) << 4) |
                    (char_to_int(mac_addr[7]) << 0));
	etheraddr[4] = ((char_to_int(mac_addr[8]) << 4) |
                    (char_to_int(mac_addr[9]) << 0));
#else
	etheraddr[3] = mac_addr[3];
	etheraddr[4] = mac_addr[4];
#endif
	etheraddr[5] = (0 << 4) | port;
}

#ifdef OUT
static void
init_hostid(uint8_t *mac)
{
	hostid = (mac[3] << 8) | mac[4];
}
#endif

void
init_ether_addrs(uint32_t ipaddr, uint8_t *mac0, uint8_t *mac1)
{
#ifdef CONFIG_ONSTOR_BOBCAT
	seepPCB_t *chassis_seep = (void *)SEEP_LOCATION;
	uint8_t *mac_addr = chassis_seep->mac_addr;
#else
	uint8_t *mac_addr = mac0;
#endif

	init_etheraddr(mac_addr, eee_ssc_ext_mac[0], 0);
	init_etheraddr(mac_addr, eee_ssc_ext_mac[1], 1);
}
