/*
 * Copyright (C) 2005 Onstor, Inc.
 *
 * First-level interrupt dispatcher for Onstor bobcat board.
 */
#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/addrspace.h>
#include <asm/regdef.h>
#include <asm/stackframe.h>

/*
 * First level interrupt dispatcher for Onstor's bobcat board
 */
		.align	5
		NESTED(bobcat_cpu_int, PT_SIZE, sp)
		SAVE_ALL
		CLI
		.set	at
		mfc0	t0, CP0_CAUSE  
		mfc0	t2, CP0_STATUS
		cfc0	t1, CP0_S1_INTCONTROL

		and	t2, t0			/* mask off ints */
        
		andi	t2, t0, STATUSF_IP2	/* int0 hardware line */
		bnezl	t2, ll_mv64x40_irq
		move	a0, sp			/* irq = 2 */

		sll	t2, t1, 8		/* look for extended ints. */
		and	t0, t2			/* mask off ints. */
		srl	t0, t0, 16		/* re-adjust to be a byte. */

		andi	t1, t0, STATUSF_IP8	/* int6 hardware line */
		bnezl	t1, ll_ns_83816
		li	a0, 8			/* irq = 8 */

		andi	t1, t0, STATUSF_IP9	/* int7 hardware line */
		bnezl	t1, ll_ns_83816
		li	a0, 9			/* irq = 9 */


		andi	t1, t0, STATUSF_IP10	/* int8 hardware line */
		bnezl	t1, ll_pcmcia_irq
		li	a0, 10			/* irq = 10 */


		andi	t1, t0, STATUSF_IP12	/* int10 hardware line */
		bnezl	t1, ll_alt_timer
		li	a0, 12			/* irq = 12 */

		.set	reorder

		/* wrong alarm or masked ... */
		j	spurious_interrupt
		nop
		END(bobcat_cpu_int)

		.align	5
ll_mv64x40_irq:					/* irq = 2 */
		jal	ll_mv64340_irq
		jal	ret_from_irq
ll_ns_83816:					/* irq = 8 and 9 */
		move	a1, sp
		jal	do_IRQ
		jal	ret_from_irq
ll_pcmcia_irq:					/* irq = 10 */
		move	a1, sp
		jal	do_IRQ
		jal	ret_from_irq
ll_alt_timer:					/* irq = 12 */
		move	a1, sp
		jal	ll_timer_interrupt
		jal	ret_from_irq
