/*
 * Copyright (C) 2005 Onstor, Inc.
 *
 */
#include <linux/init.h>
#include <linux/interrupt.h>
#include <linux/signal.h>
#include <linux/types.h>
#include <asm/irq_cpu.h>
#include <asm/time.h>
#include <asm/mipsregs.h>
#include <linux/mv643xx.h>

#define CAUSEF_IP8	(_ULCAST_(1) << 16)
#define	CAUSEF_IP9	(_ULCAST_(1) << 17)
#define CAUSEF_IP10	(_ULCAST_(1) << 18)
#define CAUSEF_IP11	(_ULCAST_(1) << 19)
#define CAUSEF_IP12	(_ULCAST_(1) << 20)
#define CAUSEF_IP13	(_ULCAST_(1) << 21)

extern asmlinkage void bobcat_cpu_int(void);
extern void ll_mv64340_irq(struct pt_regs *regs);

static struct irqaction generic_mv64340 = {
	no_action, SA_INTERRUPT, CPU_MASK_NONE, "generic MV64340 int",
	NULL, NULL};

void __init arch_init_irq(void)
{
	/* disable cpu interrupt before enabling it. */
	clear_c0_status(ST0_IM);

	/* enable first-level cpu interrupt */
	set_except_vector(0, bobcat_cpu_int);

	/* enable interrupt to irq mapping. */
	mips_cpu_irq_init(0);
	/* enable alternate timer interrupt. */
	rm9k_cpu_irq_init(8);

	/* initialize marvell interrupt handlers. */
	setup_irq(3, &generic_mv64340);
	mv64340_irq_init(16);

	/* enable cpu interrupts. */
	set_c0_status(ST0_IM);
}

static int onstor_spurious_cnt = 0;

asmlinkage void onstor_irq(struct pt_regs *regs)
{
	unsigned int pending, mask, intr;

	/* grab pending interrupts */
	pending = read_c0_cause();
	/* mask out disabled interrupts. */
	mask = ((read_c0_status() | (read_c0_intcontrol() & 0xff00) << 8));
	intr = pending & mask;
	if (intr) {
		if (intr & CAUSEF_IP12) {
			ll_timer_interrupt(12, regs);
			return;
		} else if (intr & CAUSEF_IP3) {
			ll_mv64340_irq(regs);
			return;
		} else if (intr & CAUSEF_IP8) {
			do_IRQ(8, regs);
			return;
		} else if (intr & CAUSEF_IP9) {
			do_IRQ(9, regs);
			return;
		} else if (intr & CAUSEF_IP10) {
			do_IRQ(10, regs);
			return;
		} else if (intr & CAUSEF_IP11) {
			do_IRQ(11, regs);
			return;
		}
	}
	if ((onstor_spurious_cnt++ % 100) == 0) {
		prom_printf("onstor_irq: pending %x mask = %x prid = %x\n",
		    pending, mask, read_c0_prid());
	}
}
