/*
 * Copyright (C) 2005 Onstor, Inc.
 *
 * First-level interrupt dispatcher for Onstor bobcat board.
 */
#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/addrspace.h>
#include <asm/regdef.h>
#include <asm/stackframe.h>

/*
 * First level interrupt dispatcher for Onstor's bobcat board
 */
		.text
		.align	5
		NESTED(bobcat_cpu_int, PT_SIZE, sp)
		SAVE_ALL
		CLI

		PTR_LA ra, ret_from_irq
		move a0, sp
		j onstor_irq

		END(bobcat_cpu_int)
