/* Marvell mv64x40 platform device IO resource definitions. The device
 * drivers for the mv64x40 chip gets the platform specific information
 * from the IO resources defined in this file. 
 *
 * Copyright (C) 2005, Onstor, Inc.
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/pci.h>
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/string.h>
#include <linux/bootmem.h>
#include <linux/spinlock.h>
#include <linux/mv643xx.h>

#include <asm/byteorder.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm/delay.h>
#include "mv64x40.h"

static struct mpsc_shared_pdata mv64x40_mpsc_shared_pdata = {
	.mrr_val	= 0,
	.rcrr_val	= 0,
	.tcrr_val	= 0,
	.intr_cause_val	= 0,
	.intr_mask_val	= 0,
};

static struct resource mv64x40_mpsc_shared_resources[] = {
	[0] = {
		.name	= "mpsc routing base",
		.start	= MPSC_MRR_ADDR,
		.end	= MPSC_MRR_ADDR +
			    MPSC_ROUTING_REG_BLOCK_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.name	= "sdma intr base",
		.start	= SDMA_INTR_CAUSE_ADDR,
		.end	= SDMA_INTR_CAUSE_ADDR +
			    MPSC_SDMA_INTR_REG_BLOCK_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	},
};

static struct platform_device mpsc_shared_device = {
	.name		= MPSC_SHARED_NAME,
	.id		= 0,
	.num_resources	= ARRAY_SIZE(mv64x40_mpsc_shared_resources),
	.resource	= mv64x40_mpsc_shared_resources,
	.dev = {
		 .platform_data = &mv64x40_mpsc_shared_pdata,
	},
};

static struct mpsc_pdata mv64x40_mpsc0_pdata = {
	.mirror_regs		= 0,
	.cache_mgmt		= 0,
	.max_idle		= 40,
	.default_baud		= 57600,
	.default_bits		= 8,
	.default_parity		= 'n',
	.default_flow		= 'n',
	.chr_1_val		= 0x00000000,
	.chr_2_val		= 0x00000000,
	.chr_10_val		= 0x00000003,
	.mpcr_val		= 0,
	.bcr_val		= 0,
	.brg_can_tune		= 0,
	.brg_clk_src		= 8,		/* Default to SYSTEM CLOCK */
	.brg_clk_freq		= 133000000,	/* Default to 133 MHz */
};

static struct resource mv64x40_mpsc0_resources[] = {			
	[0] = {
		.name	= "mpsc 0 base",
		.start	= MV64x40_MPSC_0_ADDR,
		.end	= MV64x40_MPSC_0_ADDR + MPSC_REG_BLOCK_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.name	= "sdma 0 base",
		.start	= MV64x40_SDMA_0_ADDR,
		.end	= MV64x40_SDMA_0_ADDR + MPSC_SDMA_REG_BLOCK_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	},
	[2] = {
		.name	= "brg 0 base",
		.start	= MV64x40_BRG_0_ADDR,
		.end 	= MV64x40_BRG_0_ADDR + MPSC_BRG_REG_BLOCK_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	},
	[3] = {
		.name	= "sdma 0 irq",
		.start	= MV64x40_IRQ_SDMA_0 + 16, /* start after cpu IRQs */ 
		.end 	= MV64x40_IRQ_SDMA_0 + 16,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device mpsc0_device = {
	.name		= MPSC_CTLR_NAME,
	.id		= 0,
	.num_resources	= ARRAY_SIZE(mv64x40_mpsc0_resources),
	.resource	= mv64x40_mpsc0_resources,
	.dev = {
		.platform_data = &mv64x40_mpsc0_pdata,
	},
};

#ifdef OUT
static struct mpsc_pdata mv64x40_mpsc1_pdata = {
	.mirror_regs		= 0,
	.cache_mgmt		= 0,
	.max_idle		= 0,
	.default_baud		= 57600,
	.default_bits		= 8,
	.default_parity		= 'n',
	.default_flow		= 'n',
	.chr_1_val		= 0x00000000,
	.chr_1_val		= 0x00000000,
	.chr_2_val		= 0x00000000,
	.chr_10_val		= 0x00000003,
	.mpcr_val		= 0,
	.bcr_val		= 0,
	.brg_can_tune		= 0,
	.brg_clk_src		= 8,		/* Default to SYSTEM CLOCK */
	.brg_clk_freq		= 133000000,	/* Default to 133 MHz */
};

static struct resource mv64x40_mpsc1_resources[] = {
	[0] = {
		.name	= "mpsc 1 base",
		.start	= MV64x40_MPSC_1_ADDR,
		.end	= MV64x40_MPSC_1_ADDR + MPSC_REG_BLOCK_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.name	= "sdma 1 base",
		.start	= MV64x40_SDMA_1_ADDR,
		.end	= MV64x40_SDMA_1_ADDR + MPSC_SDMA_REG_BLOCK_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	},
	[2] = {
		.name	= "brg 1 base",
		.start	= MV64x40_BRG_1_ADDR,
		.end	= MV64x40_BRG_1_ADDR + MPSC_BRG_REG_BLOCK_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	},
	[3] = {
		.name	= "sdma 1 irq",
		.start	= MV64x40_IRQ_SDMA_1 + 16, /* start after cpu IRQs */
		.end	= MV64x40_IRQ_SDMA_1 + 16,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device mpsc1_device = {
	.name		= MPSC_CTLR_NAME,
	.id		= 1,
	.num_resources	= ARRAY_SIZE(mv64x40_mpsc1_resources),
	.resource	= mv64x40_mpsc1_resources,
	.dev = {
		.platform_data = &mv64x40_mpsc1_pdata,
	},
};
#endif

/* list of mv64x40 platform devices. */
static struct platform_device *mv64x40_pd_devs[] __initdata = {
	&mpsc_shared_device,
	&mpsc0_device,
#ifdef OUT
	&mpsc1_device,
#endif
};

/*
 * Add the mv64x40 platform devices to the list of platform devices.
 */
static int __init
mv64x40_add_pds(void)
{
	return (platform_add_devices(mv64x40_pd_devs,
	    ARRAY_SIZE(mv64x40_pd_devs)));
}

arch_initcall(mv64x40_add_pds);
