/*
 * Marvell mv64x40 chip specific defines.
 * Copyright (C) 2005, Onstor, Inc.
 */

#ifndef __mv64x40_h
#define __mv64x40_h

/*
 * use physcial address because it will be remapped by
 * ioremap() when the driver allocates the resource.
 */
#define MV64x40_BASE_ADDR		0xbc000000
#define MV64x40_PHYS_ADDR		CPHYSADDR(MV64x40_BASE_ADDR)

/* shared registers. */
#define MV64x40_MPSC_ROUTING_OFFSET	0xb400
#define MV64x40_SDMA_INTR_OFFSET	0xb800

#define SDMA_INTR_MASK	0x80
#define MPSC_RCRR	0x4
#define MPSC_TCRR	0x8

#define MV64x40_SDMA_0_OFFSET		0x4000
#define MV64x40_SDMA_1_OFFSET		0x6000
#define MV64x40_MPSC_0_OFFSET		0x8000
#define MV64x40_MPSC_1_OFFSET		0x9000
#define MV64x40_BRG_0_OFFSET		0xb200
#define MV64x40_BRG_1_OFFSET		0xb208

#define MPSC_MRR_ADDR		MV64x40_PHYS_ADDR + MV64x40_MPSC_ROUTING_OFFSET
#define SDMA_INTR_CAUSE_ADDR	MV64x40_PHYS_ADDR + MV64x40_SDMA_INTR_OFFSET

#define MV64x40_MPSC_0_ADDR	MV64x40_PHYS_ADDR + MV64x40_MPSC_0_OFFSET
#define MV64x40_MPSC_1_ADDR	MV64x40_PHYS_ADDR + MV64x40_MPSC_1_OFFSET
#define MV64x40_SDMA_0_ADDR	MV64x40_PHYS_ADDR + MV64x40_SDMA_0_OFFSET
#define MV64x40_SDMA_1_ADDR	MV64x40_PHYS_ADDR + MV64x40_SDMA_1_OFFSET
#define MV64x40_BRG_0_ADDR	MV64x40_PHYS_ADDR + MV64x40_BRG_0_OFFSET
#define MV64x40_BRG_1_ADDR	MV64x40_PHYS_ADDR + MV64x40_BRG_1_OFFSET

#define MV64x40_IRQ_SDMA_0	36
#define	MV64x40_IRQ_SDMA_1	38
#define MV64x40_IRQ_BRG		39
#define MV64x40_IRQ_MPSC_0	40
#define MV64x40_IRQ_MPSC_1	42

#endif /* mv64x40_h */
