/*
 * Pmon prom should initialize the PCI configuration headers for
 * the pci-pcmcia controller chip (intel pd-6729) and the natsemi
 * ethernet chip (dp-83816).
 * pd-6729:	irq = 10 	bar0/IO = 0x18000000	size = 8MB
 * 				bar1/MEM = 0x18800000	size = 8MB
 * dp-83816: 0	irq = 9		bar0/MEM = 0x19000000	size = 8MB
 *	     1 	irq = 8		bar0/MEM = 0x19800000	size = 8MB
 *
 * Copyright (C) 2005, Onstor, Inc.
 */
#include <linux/types.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/init.h>

#include <asm/pci.h>
#include <asm/io.h>

#define BOBCAT_ENET_IRQ	8
#define BOBCAT_CF_IRQ	10

struct resource cf_init_res[] = {
	{
		.start = 0x18000000,
		.end = 0x187fffff,
		.flags = IORESOURCE_IO,
	},
/* Not used.
	{
		.start = 0x18800000,
		.end = 0x18ffffff,
		.flags = IORESOURCE_MEM,
	},
*/
};

struct resource natsemi_init_res[] = {
	{
		.start = 0x19000000,
		.end = 0x197fffff,
		.flags = IORESOURCE_MEM,
	},
	{
		.start = 0x19800000,
		.end = 0x19ffffff,
		.flags = IORESOURCE_MEM,
	},
};

/*
 * fixup the pci-pcmcia chip.
 */
static void
bobcat_pci_pcmcia_6729_fixup_header(struct pci_dev *dev)
{
	dev->irq = BOBCAT_CF_IRQ;
	dev->resource[0].start = cf_init_res[0].start;
	dev->resource[0].end = cf_init_res[0].end;
	dev->resource[0].flags = cf_init_res[0].flags;
	dev->resource[1].start = 0;
	dev->resource[1].end = 0;
	dev->resource[1].flags = 0;
	dev->resource[6].start = 0;
	dev->resource[6].end = 0;
	dev->resource[6].flags = 0;
}

/*
 * fixup the natsemi ethernet chip.
 */
static void
bobcat_pci_ns_83816_fixup_header(struct pci_dev *dev)
{
	static int unit = 0;
	
	dev->irq = BOBCAT_ENET_IRQ + unit;
	dev->resource[0].start = 0;
	dev->resource[0].end = 0;
	dev->resource[0].flags = 0;
	dev->resource[1].start = natsemi_init_res[unit].start;
	dev->resource[1].end = natsemi_init_res[unit].end;
	dev->resource[1].flags = natsemi_init_res[unit].flags;
	dev->resource[6].start = 0;
	dev->resource[6].end = 0;
	dev->resource[6].flags = 0;
	unit++;
}

DECLARE_PCI_FIXUP_HEADER(PCI_VENDOR_ID_NS, PCI_DEVICE_ID_NS_83815,
    bobcat_pci_ns_83816_fixup_header);

DECLARE_PCI_FIXUP_HEADER(PCI_VENDOR_ID_CIRRUS, PCI_DEVICE_ID_CIRRUS_6729,
    bobcat_pci_pcmcia_6729_fixup_header);
