/*
 * Copyright (C) 2005, Onstor, Inc.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/bootmem.h>

#include <asm/addrspace.h>
#include <asm/bootinfo.h>
#include <asm/pmon.h>

extern void init_ether_addrs(uint32_t ipaddr, uint8_t *mac0, uint8_t *mac1);

struct callvectors *debug_vectors;

const char *get_system_type(void)
{
	return ("Onstor Bobcat");
}

/*
 * convert an ip address that is stored as a string. for example,
 * ip address 192.0.10.2 is converted to the string "2.10.0.192".
 */
static unsigned int
strtoip(char *str, unsigned int base)
{
	char *p = str;
	char *e;
	uint32_t res = 0;
	int i;

prom_printf("stroip: str = %s\n", str);
	for (i = 0; i < 4; i++) {
		res |= simple_strtoul(p, &e, base) << (i * 8);
		/* skip "." in the ip address string. */
		p = e + 1;
	}
prom_printf("strtoip: ip = %d.%d.%d.%d\n", NIPQUAD(res));
	return (res);
}

long	my_ipaddr;
long	my_netmask;
long	my_memsize;
char	*my_mac0addr;
char	*my_mac1addr;
long	bus_clock;
unsigned long cpu_clock;
extern unsigned long	marvell_base;

extern void DebugPortOn(void);
extern int mpsc_early_cons_init(void);

/* PMON passes arguments in C main() style */
void __init prom_init(void)
{
	int argc = fw_arg0;
	char **arg = (char **) fw_arg1;
	char **env = (char **) fw_arg2;
	struct callvectors *cv = (struct callvectors *) fw_arg3;
	char *my_mac0str = NULL, *my_mac1str = NULL;
	char *ptr;
	int i;

	DebugPortOn();
	prom_printf("ONSTOR-bobcat\n");
	(void) mpsc_early_cons_init();
	/* save the PROM vectors for debugging use */
	debug_vectors = cv;

	ptr = &(arcs_cmdline[0]);
	/* always ignore argv[0] */
	for (i = 1; i < argc; i++) {
		strcpy(ptr, arg[i]);
		ptr += strlen(arg[i]);
		*ptr++ = ' ';
	}
prom_printf("prom_init: arcs_cmdline = %s, i = %d\n", arcs_cmdline, i);

	for (; *env; env++) {
		if (strncmp("ipaddr", *env, strlen("ipaddr")) == 0) {
			my_ipaddr = strtoip(*env +
					    strlen("ipaddr="), 10);
			continue;
		}
		if (strncmp("netmask", *env, strlen("netmask")) == 0) {
			my_netmask = strtoip(*env +
					    strlen("netmask="), 10);
			continue;
		}
		if (strncmp("macaddr0", *env, strlen("macaddr0")) == 0) {
			my_mac0str = *env + strlen("macaddr0=");
			continue;
		}
		if (strncmp("macaddr1", *env, strlen("macaddr1")) == 0) {
			my_mac1str = *env + strlen("macaddr1=");
			continue;
		}
		if (strncmp("memsize", *env, strlen("memsize=")) == 0) {
			my_memsize = simple_strtol(*env + strlen("memsize="),
								NULL, 10);
			continue;
		}
		if (strncmp("gtbase", *env, strlen("gtbase")) == 0) {
			marvell_base = simple_strtol(*env + strlen("gtbase="),
							NULL, 16);
			continue;
		}
		if (strncmp("cpuclock", *env, strlen("cpuclock")) == 0) {
			cpu_clock = simple_strtol(*env + strlen("cpuclock="),
							NULL, 10);
prom_printf("cpu_clock = %d\n", cpu_clock);
			continue;
		}
		if (strncmp("busclock", *env, strlen("busclock")) == 0) {
			bus_clock = simple_strtol(*env + strlen("busclock="),
							NULL, 10);
prom_printf("bus_clock = %d\n", bus_clock);
			continue;
		}
	}

	mips_machgroup = MACH_GROUP_ONSTOR;
	mips_machtype = MACH_ONSTOR_BOBCAT;

	init_ether_addrs(htonl(my_ipaddr), my_mac0str, my_mac1str);
}

void __init prom_free_prom_memory(void)
{
}

void __init prom_fixup_mem_map(unsigned long start, unsigned long end)
{
}

int prom_boot_secondary(int cpu, unsigned long sp, unsigned long gp)
{
	/* Clear the semaphore */
	*(volatile uint32_t *)(0xbb000a68) = 0x80000000;

	return 1;
}

void prom_init_secondary(void)
{
        clear_c0_config(CONF_CM_CMASK);
        set_c0_config(0x2);

	clear_c0_status(ST0_IM);
	set_c0_status(0x1ffff);
}

void prom_smp_finish(void)
{
}
