/*
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 *
 * Copyright (C) 1997, 2001 Ralf Baechle
 * Copyright 2001 MontaVista Software Inc.
 * Author: jsun@mvista.com or jsun@junsun.net
 *
 * Copyright (C) 2002 Momentum Computer Inc.
 * Author: Matthew Dharm <mdharm@momenco.com>
 *
 * Louis Hamilton, Red Hat, Inc.
 * hamilton@redhat.com  [MIPS64 modifications]
 *
 * Copyright (C) 2005 Onstor, Inc.
 */
#include <linux/config.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include <asm/processor.h>
#include <asm/reboot.h>
#include <asm/system.h>
#include <linux/delay.h>

extern void ds1511_start_wdtimer(int onceflag, int resetflag);

static void
onstor_bobcat_wait(void)
{
	__asm__(".set\tmips3\n\t"
                "wait\n\t"
		".set\tmips0");
}

void onstor_bobcat_restart(char *command)
{
	/* restart watchdog to expire by setting the once flag. */
	ds1511_start_wdtimer(1, 1);
	onstor_bobcat_wait();
}

void onstor_bobcat_halt(void)
{
	printk(KERN_NOTICE "\n** You can safely turn off the power\n");
	while (1)
		onstor_bobcat_wait();
}

void onstor_bobcat_power_off(void)
{
	onstor_bobcat_halt();
}
