#ifndef __NETEEE_EEE_H
#define __NETEEE_EEE_H


struct eee_addr {
	uint8_t eee_bplane;
	uint8_t eee_slot;
	uint8_t eee_cpu;
	uint16_t eee_app;
};


struct sockaddr_eee {
	uint8_t seee_len;
	uint8_t seee_family;
	struct eee_addr seee_addr;
#define seee_bplane seee_addr.eee_bplane
#define seee_slot seee_addr.eee_slot
#define seee_cpu seee_addr.eee_cpu
#define seee_app seee_addr.eee_app
};

extern uint32_t nfxMySlotId;
extern uint32_t nfxMyCPUId;

extern struct domain eeedomain;
extern struct sockaddr_eee eee_netmask;
extern struct sockaddr_eee eee_hostmask;

extern uint8_t eee_broadslot;
extern uint8_t eee_broadcpu;
extern uint8_t eee_broadplane;

#define EEE_SENDQ (32*1024)
#define EEE_RECVQ (32*1024)

/* Values defined to match nfx-tree/code/sm-eee/eee-desc.h.
 */
#define EDESC2_SLOT_NUM  16
#define EDESC2_CPU_NUM   32
#define EDESC2_APP_NUM   4096 

#define EEE_RESERVED_APP 1024
#define EEE_MAXBACKPLANE 2
#define EEE_MAXSLOT EDESC2_SLOT_NUM
#define EEE_MAXCPU EDESC2_CPU_NUM
#define EEE_MAXAPP EDESC2_APP_NUM

#define EEE_NULLAPP (0)
#define EEE_NULLSLOT (EEE_MAXSLOT - 2)
#define EEE_NULLCPU (EEE_MAXCPU - 2)
#define EEE_BROADSLOT (EEE_MAXSLOT - 1)
#define EEE_BROADCPU (EEE_MAXCPU - 1)
#define EEE_BROADBPLANE (EEE_MAXBACKPLANE + 1)

#define EEE_DATABPLANE 1
#define EEE_CONTROLBPLANE 2

#ifdef _KERNEL

extern struct eee_addr zeroeee_addr;

#define eee_nullhost(x) ((x).eee_cpu == EEE_NULLCPU \
						 && (x).eee_slot == EEE_NULLSLOT)
#define eee_hosteq(x,y) ((x).eee_cpu == (y).eee_cpu && \
						 (x).eee_slot == (y).eee_slot)
#define eee_neteq(x,y)  ((x).eee_bplane == (y).eee_bplane)
#define eee_neteqnn(x,y) (x == y)
#define satoeee_addr(sa) (((struct sockaddr_eee *)&(sa))->seee_addr)
#define seeetosa(sa)   ((struct sockaddr *)sa)
#define satoseee(sa)   ((struct sockaddr_eee *)sa)
#define eee_isbroadcast(sa) ((sa).eee_cpu == EEE_BROADCPU && \
							 (sa).eee_slot == EEE_BROADSLOT)

// void eee_init __P((void));
void eee_init (void);
// void eee_input __P((struct mbuf *, ...));
void eee_input (struct mbuf *, ...);
void eeeintr __P((void));
int	eee_output __P((struct mbuf *m0, ...));
int eee_control __P((struct socket *so, u_long cmd,
					 caddr_t data, struct ifnet *ifp));
int	eee_usrreq __P((struct socket *so, int req, struct mbuf *m,
			struct mbuf *nam, struct mbuf *control));
int	eee_sysctl __P((int *, u_int, void *, size_t *, void *, size_t));
void eee_printhost __P((struct eee_addr *addr));
int eee_msgtobplane __P((int msgtype));
int eee_bplanetomsg __P((int bplane));
void eee_printhost __P((struct eee_addr *addr));
void eee_print_agile_hdr __P((char *s, agile_hdr_t *));
void eee_slowtimo(void);

#endif

#endif
