/*	$OpenBSD: eee_if.h,v 1.3 1997/07/23 20:37:20 mickey Exp $	*/

/*-
 *
 * Copyright (c) 1996 Michael Shalayeff
 * Copyright (c) 1995, Mike Mitchell
 * Copyright (c) 1984, 1985, 1986, 1987, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 *	@(#)eee_if.h
 *
 * from FreeBSD Id: eee_if.h,v 1.5 1995/11/24 12:25:05 bde Exp
 */

#ifndef _NETEEE_EEE_IF_H_
#define	_NETEEE_EEE_IF_H_

#define ETHERTYPE_EEE 0x2200

/*
 * Interface address.  One of these structures
 * is allocated for each interface with an internet address.
 * The ifaddr structure contains the protocol-independent part
 * of the structure and is assumed to be first.
 */

struct eee_ifaddr {
	struct	ifaddr ia_ifa;		/* protocol-independent info */
#define	ia_ifp		ia_ifa.ifa_ifp
#define	ia_flags	ia_ifa.ifa_flags
	TAILQ_ENTRY(eee_ifaddr)	ia_list;/* list of EEE addresses */
	struct	sockaddr_eee ia_addr;	/* reserve space for my address */
	struct	sockaddr_eee ia_dstaddr;/* space for my broadcast address */
#define ia_broadaddr	ia_dstaddr
	struct	sockaddr_eee ia_netmask;/* space for my network mask */
};

struct	eee_aliasreq {
	char	ifra_name[IFNAMSIZ];		/* if name, e.g. "en0" */
	struct	sockaddr_eee ifra_addr;
	struct	sockaddr_eee ifra_dstaddr;
#define ifra_broadaddr ifra_dstaddr
};
/*
 * Given a pointer to an eee_ifaddr (ifaddr),
 * return a pointer to the addr as a sockadd_eee.
 */

#define	IA_SEEE(ia) (&(((struct eee_ifaddr *)(ia))->ia_addr))

#ifdef	EEEIP
struct eeeip_req {
	struct sockaddr rq_eee;	/* must be eee format destination */
	struct sockaddr rq_ip;	/* must be ip format gateway */
	u_int16_t	rq_flags;
};
#endif

#ifdef	_KERNEL
TAILQ_HEAD(eee_ifaddrhead, eee_ifaddr);
extern struct	ifqueue	eeeintrq;	/* EEE input packet queue */
extern struct	eee_ifaddrhead eee_ifaddr;

struct eee_ifaddr *eee_iaonnetof __P((struct eee_addr *dst, int bplane));
int	eee_ifinit __P((struct ifnet *ifp, struct eee_ifaddr *ia,
					struct sockaddr_eee *seee, int scrub));
void eee_ifscrub __P((struct ifnet *ifp, struct eee_ifaddr *ia));

struct eee_ifaddr *eee_find_interface __P((int bplane, int slot, int cpu));

int ifeee_output __P((struct ifnet *ifp, struct mbuf *m0,
					  struct sockaddr *dst, struct rtentry *rt0));

void eee_addrtoether  __P((struct sockaddr_eee *seee, u_char *edst));
struct ifaddr *eee_iseeeifp __P((struct ifnet *ifp));

#endif

struct eee_attachreq {
	char name[IFNAMSIZ];
	struct sockaddr_eee addr;
	unsigned int link;
	uint8_t ether_addr[6];
};

int ethereee_ifattach(struct eee_attachreq *req);
int ethereee_ifdetach(struct eee_attachreq *req);
int ethereee_ifset(struct eee_attachreq *req);

#define SIOCETHEEEATTACH _IOW('s', 80, struct eee_attachreq)
#define SIOCETHEEEDETACH _IOW('s', 81, struct eee_attachreq)
#define SIOCETHEEESET _IOW('s', 82, struct eee_attachreq)

#endif /* !_NETEEE_EEE_IF_H_ */
