#ifndef _NETEEE_EEE_PCB_H_
#define	_NETEEE_EEE_PCB_H_

/*
 * EEE protocol interface control block.
 */
struct eeepcb {
	struct	socket		*eeep_socket;	/* back pointer to socket */
	struct	eee_addr	eeep_faddr;	/* destination address */
	struct	eee_addr	eeep_laddr;	/* socket's address */
	int		 			eeep_last_cc;
	uint32_t			eeep_genid;
#ifdef NETEEE_ALIAS
	TAILQ_ENTRY(eeepcb) eeep_list; /* if multiple addresses allowed,
									  list of addresses in table */
#endif
#define eeep_lapp eeep_laddr.eee_app
#define eeep_fapp eeep_faddr.eee_app
};



struct eeepcbtable {
	uint16_t eeept_lapp;
#ifdef NETEEE_ALIAS
	TAILQ_HEAD(eeept_pcbhead, eeepcb) eeept_pcbs[EEE_MAXAPP];
#else
	struct eeepcb *eeept_pcbs[EEE_MAXAPP];
#endif
};

#define	sotoeeepcb(so)		((struct eeepcb *)((so)->so_pcb))

/*
 * Nominal space allocated to a EEE socket.
 */
#define	EEESNDQ		16384
#define	EEERCVQ		40960

#ifdef _KERNEL
extern struct eeepcbtable eeecbtable;

void	eee_pcbinit __P((void));
int	eee_pcballoc __P((struct socket *so));
int	eee_pcbbind __P((struct eeepcb *eeep, struct mbuf *nam));
int	eee_pcbconnect __P((struct eeepcb *eeep, struct mbuf *nam));
void	eee_pcbdetach __P((struct eeepcb *eeep));
int 	eee_pcbdisconnect __P((struct eeepcb *eeep));
struct eeepcb *eee_pcblookup __P((struct eee_addr *));
void	eee_pcbnotify __P((struct eee_addr *dst, int errno,
			   void (*notify)(struct eeepcb *), long param));
void	eee_setpeeraddr __P((struct eeepcb *eeep, struct mbuf *nam));
void	eee_setsockaddr __P((struct eeepcb *eeep, struct mbuf *nam));
void    eee_sendwupdate __P((struct eeepcb *eeep));
int eee_send __P((struct eeepcb *eeep, struct mbuf *m, struct mbuf *nam,
				  struct mbuf *control));


#endif

#endif /* !_NETEEE_EEE_PCB_H_ */
