/*	$OpenBSD: ipx_var.h,v 1.5 2000/01/17 00:34:00 fgsch Exp $	*/

/*-
 *
 * Copyright (c) 1996 Michael Shalayeff
 * Copyright (c) 1995, Mike Mitchell
 * Copyright (c) 1984, 1985, 1986, 1987, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)eee_var.h
 *
 * from FreeBSD Id: eee_var.h,v 1.3 1995/11/04 09:03:27 julian Exp
 */

#ifndef _NETEEE_EEE_VAR_H_
#define _NETEEE_EEE_VAR_H_

/*
 * EEE Kernel Structures and Variables
 */
struct	eeestat {
	u_long  eees_total;             /* total packets received */
	u_long  eees_tooshort;          /* packet too short */
	u_long  eees_toosmall;          /* not enough data */
	u_long	eees_fragments;			/* Fragments received */
	u_long  eees_badfrags;		/* Mailformed fragments */
	u_long  eees_reassembled;	/* Successfully reassembled */
	u_long  eees_delivered;         /* datagrams delivered to upper level*/
	u_long  eees_localout;          /* total eee packets generated here */
	u_long  eees_odropped;          /* lost packets due to nobufs, etc. */
	u_long  eees_fragmented;	/* Packet required fragmentation */
	u_long  eees_ofragments;	/* Output fragments */
	u_long	eees_nopcb;			/* No protocol control block */
	u_long  eees_timeout;		/* Packet timed out */
	u_long  eees_badoff;		/* received packet with bad fragment
								   offset */
	u_long  eees_noqueue;		/* No fragment queue for the packet */
	u_long  eees_rcvnomem;		/* receive packet dropped due to no
								 memory */
	u_long 	eees_notours;		/* Bad packet destination */
};

/*
 * names for EEE sysctl objects.
 */

#define	EEECTL_CHECKSUM		1
#define EEECTL_FORWARDING	2
#define EEECTL_NETBIOS		3
#define EEECTL_RECVSPACE	4
#define EEECTL_SENDSPACE	5
#define	EEECTL_MAXID		6

#define EEECTL_NAMES { \
	{ 0, 0}, \
	{ "checksum", CTLTYPE_INT }, \
	{ "forwarding", CTLTYPE_INT }, \
	{ "netbios", CTLTYPE_INT }, \
	{ "recvspace", CTLTYPE_INT }, \
	{ "sendspace", CTLTYPE_INT }, \
}

#ifdef _KERNEL
extern struct eeestat eeestat;
#endif

#endif
